theory question_5_7

imports Main

begin

typedecl entity
typedecl event

consts
  FootballPlayer :: "entity ⇒ bool"
  Player :: "entity ⇒ bool"
  Plays :: "entity ⇒ entity ⇒ bool"
  Football :: "entity ⇒ bool"
  Field :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Located :: "entity ⇒ entity ⇒ bool"
  
(* Explanation 1: A football player is a player who plays football. *)
axiomatization where
  explanation_1: "∀x. FootballPlayer x ⟷ Player x ∧ (∃y. Plays x y ∧ Football y)"
  
(* Explanation 2: If a player is on a field, then they are located on the field. *)
axiomatization where
  explanation_2: "∀x y. Player x ∧ Field y ∧ On x y ⟶ Located x y"

theorem hypothesis:
  (* Premise: A football player in a blue 'Rams' jersey runs with a football on a field, as another player in a white jersey falls in an attempt to tackle him. *)
  assumes asm: "FootballPlayer x ∧ Blue 'Rams' y ∧ Jersey x y ∧ Runs x z ∧ Football z ∧ Field w ∧ On z w ∧ Player w ∧ White x' ∧ Jersey w x' ∧ Falls w"
  (* Hypothesis: The football players are on a field. *)
  shows "∃x y. FootballPlayer x ∧ Field y ∧ Located x y"
proof -
  from asm have "FootballPlayer x" by (rule explanation_1)
  then have "Player x" by (rule imp_trans[OF explanation_1(1)])
  from asm have "Field w" by auto
  from asm have "On z w" by auto
  from asm have "Player w" by auto
  from asm have "Located z w" using explanation_2 by blast
  show ?thesis using `FootballPlayer x` `Field w` `Located z w` by blast
qed

end
