theory question_75_0
imports Main

begin

typedecl entity
typedecl event

consts
  Slow :: "event ⇒ bool"
  SlowDown :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Decreases :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Speed :: "entity ⇒ bool"
  Friction :: "entity ⇒ bool"
  Object :: "entity ⇒ bool"
  Motion :: "event ⇒ bool"
  Acts :: "entity ⇒ event ⇒ bool"
  Counter :: "event ⇒ bool"
  Surface :: "entity ⇒ bool"
  Touching :: "event ⇒ bool"
  Contact :: "entity ⇒ entity ⇒ bool"
  PartOf :: "entity ⇒ entity ⇒ bool"
  Pushing :: "event ⇒ bool"
  Pulling :: "event ⇒ bool"
  Reduce :: "event ⇒ entity ⇒ bool"
  Stop :: "event ⇒ bool"
  Resist :: "event ⇒ bool"
  Rolling :: "event ⇒ bool"
  Ball :: "entity ⇒ bool"
  Force :: "entity ⇒ bool"
  Type :: "entity ⇒ entity ⇒ bool"
  Kind :: "entity ⇒ entity ⇒ bool"
  FrictionalForces :: "entity ⇒ bool"
  SoccerBall :: "entity ⇒ bool"

(* Explanation 1: to slow; to slow down decreases speed. *)
axiomatization where
  explanation_1: "∀x e1 e2. Slow e1 ∧ Agent e1 x ∧ SlowDown e2 ∧ Agent e2 x ∧ Decreases e2 (Speed x)"

(* Explanation 2: friction acts to counter the motion of two objects when their surfaces are touching. *)
axiomatization where
  explanation_2: "∀x y z e1 e2 w1 w2. Friction x ∧ Object y ∧ Object z ∧ Motion e1 ∧ Patient e1 y ∧ Patient e1 z ∧ Acts x e2 ∧ Counter e2 ∧ Agent e2 x ∧ Surface w1 ∧ Surface w2 ∧ Patient w1 y ∧ Patient w2 z ∧ Touching e3 ∧ Agent e3 w1 ∧ Patient e3 w2"

(* Explanation 3: to touch means to contact. *)
axiomatization where
  explanation_3: "∀x y. Touch x y ⟷ Contact x y"

(* Explanation 4: a surface is a part of an object. *)
axiomatization where
  explanation_4: "∀x y. Surface x ⟶ PartOf x (Object y)"

(* Explanation 5: pushing is a kind of motion. *)
axiomatization where
  explanation_5: "∀x. Pushing x ⟶ Motion x"

(* Explanation 6: pulling is a kind of motion. *)
axiomatization where
  explanation_6: "∀x. Pulling x ⟶ Motion x"

(* Explanation 7: counter means reduce; stop; resist. *)
axiomatization where
  explanation_7: "∀x. Counter x ⟷ Reduce x ∨ Stop x ∨ Resist x"

(* Explanation 8: to reduce means to decrease. *)
axiomatization where
  explanation_8: "∀x y. Reduce x y ⟷ Decrease x y"

(* Explanation 9: rolling is a kind of motion. *)
axiomatization where
  explanation_9: "∀x. Rolling x ⟶ Motion x"

(* Explanation 10: a ball is a kind of object. *)
axiomatization where
  explanation_10: "∀x. Ball x ⟶ Object x"

(* Explanation 11: friction is a kind of force. *)
axiomatization where
  explanation_11: "∀x. Friction x ⟶ Force x"

(* Explanation 12: a type is synonymous with a kind. *)
axiomatization where
  explanation_12: "∀x y. Type x y ⟷ Kind x y"

theorem hypothesis:
  assumes asm: "FrictionalForces x ∧ SoccerBall y ∧ Rolling e1 ∧ SlowDown e1 ∧ Agent e1 x ∧ Patient e1 y"
  (* Hypothesis: Frictional forces slowing down a rolling soccer ball is a type of force that requires contact between two objects for one to push or pull the other. *)
  shows "∃x y z e1 e2 w1 w2 e3 e4. FrictionalForces x ∧ SoccerBall y ∧ Rolling e1 ∧ SlowDown e1 ∧ Agent e1 x ∧ Patient e1 y ∧ TypeOfForce x ∧ Contact e2 ∧ Requires x e2 ∧ Object z1 ∧ Object z2 ∧ Patient e2 z1 ∧ Patient e2 z2 ∧ Pushing e3 ∨ Pulling e4 ∧ Agent e3 z1 ∧ Patient e3 z2 ∨ Agent e4 z1 ∧ Patient e4 z2"
proof -
  {
    assume asm: "FrictionalForces x ∧ SoccerBall y ∧ Rolling e1 ∧ SlowDown e1 ∧ Agent e1 x ∧ Patient e1 y"
    from asm have "SoccerBall y" by simp
    from explanation_10 have "Object y" using `SoccerBall y` by blast
    from asm have "Rolling e1" by simp
    from explanation_9 have "Motion e1" using `Rolling e1` by blast
    from asm have "SlowDown e1" by simp
    from explanation_1 have "Decreases e1 (Speed y)" using `SlowDown e1` `Agent e1 x` `Patient e1 y` by blast
    from asm have "FrictionalForces x" by simp
    from explanation_11 have "Force x" using `FrictionalForces x` by blast
    from explanation_2 have "∃z1 z2 w1 w2 e2 e3. Friction x ∧ Object z1 ∧ Object z2 ∧ Motion e2 ∧ Patient e2 z1 ∧ Patient e2 z2 ∧ Acts x e3 ∧ Counter e3 ∧ Agent e3 x ∧ Surface w1 ∧ Surface w2 ∧ Patient w1 z1 ∧ Patient w2 z2 ∧ Touching e2 ∧ Agent e2 w1 ∧ Patient e2 w2" using `Force x` `Object y` `Motion e1` by blast
    then obtain z1 z2 w1 w2 e2 e3 where e2: "Friction x ∧ Object z1 ∧ Object z2 ∧ Motion e2 ∧ Patient e2 z1 ∧ Patient e2 z2 ∧ Acts x e3 ∧ Counter e3 ∧ Agent e3 x ∧ Surface w1 ∧ Surface w2 ∧ Patient w1 z1 ∧ Patient w2 z2 ∧ Touching e2 ∧ Agent e2 w1 ∧ Patient e2 w2" by blast
    from explanation_3 have "Contact e2 w1 w2" using e2 by blast
    from explanation_4 have "PartOf w1 (Object z1)" using e2 by blast
    from explanation_4 have "PartOf w2 (Object z2)" using e2 by blast
    from explanation_7 have "Reduce e3 z1 ∨ Reduce e3 z2 ∨ Stop e3 ∨ Resist e3" using e2 by blast
    from explanation_8 have "Decrease e3 z1 ∨ Decrease e3 z2 ∨ Stop e3 ∨ Resist e3" using e2 by blast
    from explanation_5 have "Pushing e4 ∨ Pulling e4" using `Motion e1` by blast
    then obtain e4 where e4: "Pushing e4 ∨ Pulling e4" by blast
    from e4 have "Pushing e4 ∨ Agent e4 z1 ∧ Patient e4 z2" by blast
    from e4 have "Pulling e4 ∨ Agent e4 z1 ∧ Patient e4 z2" by blast
    then have "Agent e4 z1 ∧ Patient e4 z2" using e2 by blast+
  }
  then show ?thesis using asm by blast
qed

end
