theory question_91_5

imports Main

begin

typedecl entity
typedecl event

consts
  Bears :: "entity ⇒ bool"
  Hibernate :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Winter :: "entity ⇒ bool"
  EnergyConservation :: "event ⇒ entity ⇒ bool"
  Method :: "event ⇒ bool"

(* Explanation 1: Bears hibernate during the winter to conserve their energy. *)
axiomatization where
  explanation_1: "∀x e w. Bears x ∧ Hibernate e ∧ Agent e x ∧ Winter w ⟶ EnergyConservation e x"

(* Explanation 2: Hibernation is a method used by bears to conserve energy. *)
axiomatization where
  explanation_2: "∀x e. Hibernate e ∧ Bears x ∧ Method e ∧ Agent e x ⟶ EnergyConservation e x"

theorem hypothesis:
  assumes asm: "Bears x ∧ Hibernate e ∧ Agent e x"
  (* Hypothesis: Bears hibernate to conserve energy. *)
  shows "EnergyConservation e x"
proof -
  from asm have "Bears x ∧ Hibernate e ∧ Agent e x" by simp
  then have "EnergyConservation e x" using explanation_1 by blast
  then have "Method e" using explanation_2 by blast
  show "EnergyConservation e x" using asm `Method e` by blast
qed

end
