theory question_53_0
imports Main

begin

typedecl entity
typedecl event

consts
  Bacteria :: "entity ⇒ bool"
  Cause :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  FoodPoisoning :: "entity ⇒ bool"
  Patient :: "event ⇒ entity"
  SeriousIllness :: "entity ⇒ bool"

(* Explanation 1: bacteria cause food poisoning *)
axiomatization where
  explanation_1: "∀x e. Bacteria x ∧ Cause e ∧ Agent e x ⟶ FoodPoisoning (Patient e)"

(* Explanation 2: Food poisoning is a serious illness *)
axiomatization where
  explanation_2: "∀x. FoodPoisoning x ⟶ SeriousIllness x"

theorem hypothesis:
  assumes asm: "Bacteria x ∧ Cause e ∧ Agent e x"
  (* Hypothesis: Bacteria cause serious illness *)
  shows "SeriousIllness  Patient e "
proof -
  from asm have "Bacteria x ∧ Cause e ∧ Agent e x" by simp
  then have "FoodPoisoning (Patient e)" using explanation_1 by blast
  then have "SeriousIllness (Patient e)" using explanation_2 by blast
  show "SeriousIllness (Patient e)" by simp
qed

end
