theory question_45_8

imports Main

begin

typedecl entity
typedecl event

consts
  Woman :: "entity ⇒ bool"
  Outdoors :: "entity ⇒ bool"
  Running :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  NextTo :: "event ⇒ entity ⇒ bool"
  In :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A person running barefoot next to two people on bicycles and a female runner outdoors is outdoor. *)
axiomatization where
  explanation_1: "∃x y z e. Person x ∧ Barefoot y ∧ TwoPeopleOnBicycles z ∧ FemaleRunner z ∧ Outdoors e ∧ Running e ∧ Agent e x ∧ NextTo e y ∧ NextTo e z"

(* Explanation 2: People are running outdoors. *)
axiomatization where
  explanation_2: "∃x y e. People x ∧ Outdoors y ∧ Running e ∧ Agent e x ∧ In e y"

theorem hypothesis:
  (* Premise: A woman in black clothing runs down the street barefoot next to two people on bicycles and a female runner. *)
  assumes asm: "Woman x ∧ BlackClothing y ∧ Barefoot z ∧ TwoPeopleOnBicycles z ∧ FemaleRunner z ∧ Running e ∧ Agent e x ∧ NextTo e y ∧ NextTo e z"
  (* Hypothesis: The woman is outdoors. *)
  shows "∃x e. Woman x ∧ Outdoors e ∧ Running e ∧ Agent e x"
proof -
  from asm have "Woman x" by blast
  from this have "Outdoors e" using explanation_1 by blast
  show ?thesis using `Woman x` `Outdoors e` by blast
qed

end
