theory question_27_2

imports Main

begin

typedecl entity
typedecl event
consts
  Man :: "entity ⇒ bool"
  Outside :: "event ⇒ bool"
  Selling :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  HardwareParts :: "entity ⇒ bool"
  DirtySidewalk :: "entity ⇒ bool"

(* Explanation 1: A man is outside if he is selling hardware parts on a dirty sidewalk. *)
axiomatization where
  explanation_1: "∀x y e. Man x ∧ Outside e ∧ Selling e ∧ Agent e x ∧ HardwareParts y ∧ DirtySidewalk y"

theorem hypothesis:
  (* Premise: A old man sells hardware parts on a dirty sidewalk. *)
  assumes asm: "OldMan x ∧ HardwareParts y ∧ DirtySidewalk y ∧ Selling e ∧ Agent e x"
  (* Hypothesis: The man is outside. *)
  shows "∃x e. Man x ∧ Outside e"
proof -
  from asm have "OldMan x" by blast
  from this have "Man x" using explanation_1 by blast
  from asm have "DirtySidewalk y" by blast
  from this have "Outside e" using explanation_1 by blast
  show ?thesis using `Man x` `Outside e` by blast
qed

end
