theory question_60_1
imports Main
begin

typedecl entity
typedecl event

consts
  PhaseChanges :: "entity ⇒ bool"
  Mass :: "entity ⇒ bool"
  Change :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Ice :: "entity ⇒ bool"
  Solid :: "entity ⇒ bool"
  Liquid :: "entity ⇒ bool"
  Melting :: "event ⇒ bool"
  Adding :: "event ⇒ bool"
  HeatEnergy :: "entity ⇒ bool"
  PhaseChange :: "event ⇒ bool"
  Weight :: "entity ⇒ bool"
  Property :: "entity ⇒ bool"
  Matter :: "entity ⇒ bool"
  Objects :: "entity ⇒ bool"
  Materials :: "entity ⇒ bool"
  Beaker :: "entity ⇒ bool"
  Windowsill :: "entity ⇒ bool"
  Containing :: "event ⇒ bool"
  Placed :: "event ⇒ bool"
  Melts :: "event ⇒ bool"

(* Explanation 1: Phase changes do not change mass. *)
axiomatization where
  explanation_1: "∀x y e. PhaseChanges x ∧ Mass y ⟶ ¬(Change e ∧ Agent e x ∧ Patient e y)"

(* Explanation 2: Ice melting means changing from a solid into a liquid by adding heat energy. *)
axiomatization where
  explanation_2: "∀x y z e1 e2. Ice x ∧ Solid y ∧ Liquid z ∧ Melting e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Adding e2 ∧ Agent e2 x ∧ Patient e2 z ⟶ HeatEnergy z"

(* Explanation 3: Melting is a kind of phase change. *)
axiomatization where
  explanation_3: "∀x. Melting x ⟶ PhaseChange x"

(* Explanation 4: Mass; weight is a property of matter; objects; materials. *)
axiomatization where
  explanation_4: "∀x y. (Mass x ∨ Weight x) ⟶ (Property y ∧ (Matter y ∨ Objects y ∨ Materials y))"

theorem hypothesis:
  (* Premise: A beaker containing 50 milliliters of ice is placed on a windowsill. *)
  (* After several hours, the ice melts. *)
  assumes asm: "Beaker x ∧ Ice y ∧ Windowsill z ∧ Containing e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Placed e2 ∧ Agent e2 x ∧ Patient e2 z" 
                "∃x e. Ice x ∧ Melts e ∧ Agent e x"
  (* Hypothesis: The mass of the ice did not change when it melted. *)
  shows "∃x y e1 e2. Ice x ∧ Mass y ∧ Melts e1 ∧ Agent e1 x ∧ ¬Change e2 ∧ Agent e2 y"
proof -
  from asm obtain e where e: "Ice x ∧ Melts e ∧ Agent e x" by blast
  then have "PhaseChange e" using explanation_3 by blast
  then have "¬(Change e ∧ Agent e x ∧ Patient e y)" using explanation_1 by blast
  then have "Mass y" using explanation_4 by blast
  show ?thesis using asm e `Mass y` `¬(Change e ∧ Agent e x ∧ Patient e y)` by blast
qed

end
