theory question_85_0

imports Main

begin

typedecl entity
typedecl event

consts
  PressureReceptors :: "entity ⇒ bool"
  Skin :: "entity ⇒ bool"
  Found :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  PacinianCorpuscles :: "entity ⇒ bool"

(* Explanation 1: Pressure receptors are found mainly in the skin. *)
axiomatization where
  explanation_1: "∀x y e. PressureReceptors x ∧ Skin y ∧ Found e ∧ Agent e x ∧ Patient e y"

(* Explanation 2: Pacinian corpuscles are pressure receptors. *)
axiomatization where
  explanation_2: "∀x. PacinianCorpuscles x ⟶ PressureReceptors x"  

theorem hypothesis:
  assumes asm: "PacinianCorpuscles x"
  (* Hypothesis: Pacinian corpuscles are found mainly in the skin. *)
  shows "∃x y e. PacinianCorpuscles x ∧ Skin y ∧ Found e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "PacinianCorpuscles x" by simp
  then have "PressureReceptors x" using explanation_2 by blast
  then obtain y e where "Skin y ∧ Found e ∧ Agent e x ∧ Patient e y" using explanation_1 by blast
  then show ?thesis using asm `Skin y` `Found e` `Agent e x` `Patient e y` by blast
qed

end
