theory question_74_0
imports Main

begin

typedecl entity
typedecl event

consts
  WoodFreePaper :: "entity ⇒ bool"
  Trees :: "entity ⇒ bool"
  Creating :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Cutting :: "event ⇒ bool"
  Require :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  NonWoodFibers :: "entity ⇒ bool"
  Paper :: "entity ⇒ bool"
  Pulped :: "event ⇒ bool"
  Fibres :: "entity ⇒ bool"
  Pulping :: "event ⇒ bool"
  Saves :: "event ⇒ bool"

(* Explanation 1: creating wood-free paper does not require cutting down trees *)
axiomatization where
  explanation_1: "∀x y z x1 x2 x3 e1 e2 e3. WoodFreePaper x ∧ Trees y ∧ Creating e1 ∧ Agent e1 x1 ∧ Cutting e2 ∧ Agent e2 x2 ⟶ ¬(Require e3 ∧ Agent e3 x3 ∧ Patient e3 x2)"

(* Explanation 2: Dozens of non-wood fibers are pulped for paper around the world. *)
axiomatization where
  explanation_2: "∀x y e. NonWoodFibers x ∧ Paper y ∧ Pulped e ∧ Agent e x ∧ Patient e y"  

theorem hypothesis:
  assumes asm: "Fibres x ∧ Paper y ∧ Trees z ∧ Pulping e1 ∧ Agent e1 x ∧ Patient e1 y"
  (* Hypothesis: Pulping fibres for paper saves trees. *)
  shows "∃x y z x1 x2 e1 e2. Fibres x ∧ Paper y ∧ Trees z ∧ Pulping e1 ∧ Agent e1 x1 ∧ Patient e1 y ∧ Saves e2 ∧ Agent e2 x2 ∧ Patient e2 z"
proof -
  from asm have "Fibres x ∧ Paper y ∧ Trees z ∧ Pulping e1 ∧ Agent e1 x ∧ Patient e1 y" by simp
  then obtain x1 x2 x3 e2 e3 where e2: "WoodFreePaper x1 ∧ Trees x2 ∧ Creating e2 ∧ Agent e2 x1 ∧ Cutting e3 ∧ Agent e3 x2" using explanation_1 by blast
  then have "NonWoodFibers x ∧ Paper y ∧ Pulped e2 ∧ Agent e2 x ∧ Patient e2 y" using explanation_2 by blast
  have conclusion: "Saves e2 ∧ Agent e2 x2 ∧ Patient e2 z" using e2 by simp
  show ?thesis using asm conclusion `NonWoodFibers x` `Paper y` `Pulped e2` `Agent e2 x` `Patient e2 y` by blast
qed

end
