theory question_17_4

imports Main

begin

typedecl entity
typedecl event

consts
  Telescope :: "entity ⇒ bool"
  Moon :: "entity ⇒ bool"
  SurfaceOf :: "entity ⇒ bool"
  Determining :: "event ⇒ bool"
  UsefulFor :: "event ⇒ entity ⇒ entity ⇒ bool"

(* Explanation 1: A telescope is most useful for determining what is on the surface of the Moon. *)
axiomatization where
  explanation_1: "∀e t m. Telescope t ∧ Moon m ∧ SurfaceOf m ∧ Determining e ∧ UsefulFor e t m"

theorem hypothesis:
  assumes asm: "Telescope t ∧ Moon m ∧ SurfaceOf m"
  (* Hypothesis: A telescope would be most useful in determining what is on the surface of the Moon. *)
  shows "∃e t m. Telescope t ∧ Moon m ∧ SurfaceOf m ∧ Determining e ∧ UsefulFor e t m"
proof -
  from asm have "Telescope t ∧ Moon m ∧ SurfaceOf m" by simp
  then obtain e where e: "Determining e ∧ UsefulFor e t m" using explanation_1 by blast
  have conclusion: "Determining e ∧ UsefulFor e t m" using e by simp
  show ?thesis using asm conclusion by blast
qed

end
