theory question_89_0
imports Main

begin

typedecl entity
typedecl event

consts
  Muscles :: "entity ⇒ bool"
  Contract :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  ArmDay :: "entity ⇒ bool"
  Bicep :: "entity ⇒ bool"
  Tricep :: "entity ⇒ bool"
  ForearmMuscles :: "entity ⇒ bool"
  Hits :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Triceps :: "entity ⇒ bool"

(* Explanation 1: Muscles can only contract. *)
axiomatization where
  explanation_1: "∀x e. Muscles x ⟶ Contract e ∧ Agent e x"

(* Explanation 2: Arm day hits the bicep, tricep and forearm muscles. *)
axiomatization where
  explanation_2: "∀x y z e. ArmDay x ∧ Bicep y ∧ Tricep z ∧ ForearmMuscles e ⟶ Hits e ∧ Agent e x ∧ Patient e x ∧ Patient e y ∧ Patient e z"

theorem hypothesis:
  assumes asm: "Triceps x"
  (* Hypothesis: Triceps can only contract. *)
  shows "∃x e. Triceps x ∧ Contract e ∧ Agent e x"
proof -
  from asm have "Triceps x" by simp
  then obtain e where e: "Contract e ∧ Agent e x" using explanation_1 by blast
  then have "Hits e ∧ Agent e x ∧ Patient e x" using explanation_2 by blast
  have conclusion: "Contract e ∧ Agent e x" using e by simp
  show ?thesis using asm conclusion by blast
qed

end
