theory question_81_2

imports Main

begin

typedecl entity
typedecl event

consts
  Population :: "entity ⇒ bool"
  GetsSmaller :: "event ⇒ bool"
  Occurs :: "event ⇒ bool"
  BottleneckEffect :: "event ⇒ bool"
  Sudden :: "entity ⇒ bool"
  ExternalMigration :: "event ⇒ bool"
  Reduction :: "event ⇒ bool"
  Lead :: "event ⇒ bool"
  PopulationSize :: "entity ⇒ bool"
  Caused :: "event ⇒ bool"
  Trigger :: "event ⇒ bool"

(* Explanation 1: Bottleneck effect occurs when a population suddenly gets much smaller. *)
axiomatization where
  explanation_1: "∀e p. Population p ∧ GetsSmaller e ∧ Occurs e ∧ BottleneckEffect e ⟶ Sudden p"

(* Explanation 2: External migration can lead to a sudden reduction in population size. *)
axiomatization where
  explanation_2: "∀e p. ExternalMigration e ∧ Reduction e ∧ Lead e ∧ PopulationSize p ⟶ Sudden p"

(* Explanation 3: The sudden reduction in population size caused by external migration can trigger the bottleneck effect. *)
axiomatization where
  explanation_3: "∀e1 e2 p. ExternalMigration e1 ∧ Reduction e1 ∧ PopulationSize p ∧ Caused e2 ∧ Trigger e2 ∧ BottleneckEffect e2 ⟶ Sudden p"

(* Explanation 4: External migration can trigger the bottleneck effect. *)
axiomatization where
  explanation_4: "∀e. ExternalMigration e ∧ Trigger e ⟶ BottleneckEffect e"

theorem hypothesis:
  assumes asm: "Occur e ∧ ExternalMigration e"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "BottleneckEffect e"
proof -
  from asm have "ExternalMigration e" by simp
  then have "Trigger e" using explanation_4 by blast
  then have "BottleneckEffect e" using explanation_4 by blast
  then show ?thesis using `ExternalMigration e` by blast
qed

end
