theory question_81_10

imports Main


begin

typedecl entity
typedecl event

consts
  Trigger :: "event ⇒ bool"
  ExternalMigration :: "event ⇒ bool"
  BottleneckEffect :: "event ⇒ bool"
  Lead :: "event ⇒ bool"
  Occur :: "event ⇒ bool"

(* Explanation 1: External migration can trigger the bottleneck effect. *)
axiomatization where
  explanation_1: "∀e. Trigger e ∧ ExternalMigration e ⟶ BottleneckEffect e"

(* Explanation 2: If external migration triggers the bottleneck effect, it directly leads to the occurrence of the bottleneck effect, ensuring that the bottleneck effect occurs as a direct consequence of the trigger event. *)
axiomatization where
  explanation_2: "∀e1 e2. Trigger e1 ∧ ExternalMigration e1 ⟶ (Lead e2 ∧ Occur e2 ∧ BottleneckEffect e2)"

(* Explanation 3: The bottleneck effect can occur with external migration, as a direct consequence of the trigger event. *)
axiomatization where
  explanation_3: "∀e1 e2. Trigger e1 ∧ ExternalMigration e1 ⟶ (Occur e2 ∧ BottleneckEffect e2)"


theorem hypothesis:
  assumes asm: "Occur e ∧ ExternalMigration e"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "BottleneckEffect e"
proof -
  from asm have "Occur e ∧ ExternalMigration e" by simp
  then have "Trigger e ∧ ExternalMigration e" using explanation_3 by blast
  then have "BottleneckEffect e" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
