theory question_41_3
imports Main
begin

typedecl entity
typedecl event

consts
  TiltOnAxis :: "event ⇒ bool"
  Causes :: "event ⇒ bool"
  ChangesInWeather :: "event ⇒ bool"
  Influences :: "event ⇒ bool"
  WeatherPatternsChange :: "event ⇒ bool"
  SeasonalVariations :: "event ⇒ bool"
  OverTime :: "event ⇒ bool"

(* Explanation 1: Earth's tilt on its rotating axis causes seasons to change. *)
axiomatization where
  explanation_1: "∀e. TiltOnAxis e ⟶ (∃e1. Causes e1 ∧ ChangesInWeather e1)"

(* Explanation 2: Earth's tilt on its rotating axis indirectly influences changes in weather patterns. *)
axiomatization where
  explanation_2: "∀e. TiltOnAxis e ⟶ (∃e1. Influences e1 ∧ WeatherPatternsChange e1)"

(* Explanation 3: Changes in weather patterns are a result of the seasonal variations caused by Earth's tilt. *)
axiomatization where
  explanation_3: "∀e. WeatherPatternsChange e ⟶ (∃e1. SeasonalVariations e1 ∧ Causes e1 ∧ TiltOnAxis e1)"

(* Explanation 4: Earth's tilt on its rotating axis causes changes in weather over time. *)
axiomatization where
  explanation_4: "∀e. TiltOnAxis e ⟶ (∃e1. Causes e1 ∧ ChangesInWeather e1 ∧ OverTime e1)"

theorem hypothesis:
  assumes asm: "TiltOnAxis e"
  (* Hypothesis: Earth's tilt on its rotating axis causes changes in weather. *)
  shows "∃e1. Causes e1 ∧ ChangesInWeather e1"
proof -
  from asm have "TiltOnAxis e" by simp
  then obtain e1 where e1: "Causes e1 ∧ ChangesInWeather e1" using explanation_1 by blast
  then obtain e2 where e2: "Influences e2 ∧ WeatherPatternsChange e2" using explanation_2 by blast
  then obtain e3 where e3: "SeasonalVariations e3 ∧ Causes e3 ∧ TiltOnAxis e3" using explanation_3 by blast
  then obtain e4 where e4: "Causes e4 ∧ ChangesInWeather e4 ∧ OverTime e4" using explanation_4 by blast
  have conclusion: "Causes e1 ∧ ChangesInWeather e1" using e1 by simp
  show ?thesis using conclusion by blast
qed

end
