theory question_49_4

imports Main

begin
typedecl entity
typedecl event

consts
  Group :: "entity ⇒ bool"
  People :: "entity ⇒ bool"
  Costumes :: "event ⇒ bool"
  Wear :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  PartOf :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A group consists of people. *)
axiomatization where
  explanation_1: "∀x. Group x ⟶ People x"

(* Explanation 2: Individuals in a group wear costumes. *)
axiomatization where
  explanation_2: "∀x y e. Group x ∧ People y ∧ Costumes e ∧ Wear e ∧ Agent e y ∧ PartOf y x"

(* Explanation 3: People wear costumes when they are part of a group. *)
axiomatization where
  explanation_3: "∀x y e. People x ∧ Group y ∧ PartOf x y ⟶ (∃e. Costumes e ∧ Wear e ∧ Agent e x)"

theorem hypothesis:
  (* Premise: a group of people are wearing costumes *)
  assumes asm: "Group x ∧ People x ∧ Costumes e ∧ Wear e ∧ Agent e x"
  (* Hypothesis: People are wearing costumes. *)
  shows "∃x e. People x ∧ Costumes e ∧ Wear e ∧ Agent e x"
proof -
  from asm have "Group x" by blast
  then have "People x" using explanation_1 by blast
  from asm have "Costumes e ∧ Wear e ∧ Agent e x" by blast
  then have "∃e. Costumes e ∧ Wear e ∧ Agent e x" using explanation_3 `People x` by blast
  then show ?thesis using `People x` by blast
qed

end
