﻿using System.Collections.Generic;
using SheetCore;

namespace SpreadsheetLLM.Heuristic
{
    internal class CoreSheet
    {
        private ISheet _sheet;

        public int Height => _sheet.Height;

        public int Width => _sheet.Width;

        /// <summary>
        /// 0-indexed coordinate of merged areas.
        /// </summary>
        public List<Boundary> MergedAreas { get; set; }

        public ICell this[int row, int col] => _sheet.Cell(row + 1, col + 1);
         
        public CoreSheet(SheetCore.ISheet sheet)
        {
            this._sheet = sheet;
            this.MergedAreas = new List<Boundary>();
            foreach (var mergedRegion in sheet.MergedRegions)
            {
                var mergedArea = new Boundary(
                    mergedRegion.FirstRow - sheet.FirstRow,
                    mergedRegion.LastRow - sheet.FirstRow,
                    mergedRegion.FirstColumn - sheet.FirstColumn,
                    mergedRegion.LastColumn - sheet.FirstColumn);

                this.MergedAreas.Add(mergedArea);
            }
        }
    }
}
