import os
from dotenv import load_dotenv
from genai import Credentials, Client
from genai.schema import TextGenerationParameters, TextGenerationReturnOptions

schemagen_prompt_tmdb="""
You are a GraphQL expert. Given the following GraphQL schema, modify the schema to produce a new query type.
You should generate modified queries first and then a single sequence_query at the end.

EXAMPLE 1

ORIGINAL SCHEMA:

type Api1KnownForEntry {
  adult: Boolean
  backdrop_path: String
  genre_ids: [Int]
  id: Int
  media_type: String
  original_language: String
  original_title: String
  overview: String
  popularity: Float
  poster_path: String
  release_date: Date
  title: String
  video: Boolean
  vote_average: Float
  vote_count: Int
}

type Api1ResultsEntry {
  adult: Boolean
  gender: Int
  id: Int
  known_for: [Api1KnownForEntry]
  known_for_department: String
  name: String
  original_name: String
  popularity: Float
  profile_path: String
}

type api1Root {
  page: Int
  results: [Api1ResultsEntry]
  total_pages: Int
  total_results: Int
}

type Query {
  query1(query: String, tmdb_access_token: String!): api1Root
    @rest(
      endpoint: "https://api.themoviedb.org/3/search/person"
      headers: [{ name: "authorization", value: "Bearer $tmdb_access_token;" }]
    )
}

type Api2CastEntry {
  adult: Boolean
  backdrop_path: String
  character: String
  credit_id: String
  genre_ids: [Int]
  id: Int
  order: Int
  original_language: String
  original_title: String
  overview: String
  popularity: Float
  poster_path: String
  release_date: Date
  title: String
  video: Boolean
  vote_average: Float
  vote_count: Int
}

type Api2CrewEntry {
  adult: Boolean
  backdrop_path: String
  credit_id: String
  department: String
  genre_ids: [Int]
  id: Int
  job: String
  original_language: String
  original_title: String
  overview: String
  popularity: Float
  poster_path: String
  release_date: String
  title: String
  video: Boolean
  vote_average: Float
  vote_count: Int
}

type api2Root {
  cast: [Api2CastEntry]
  crew: [Api2CrewEntry]
  id: Int
}

type Query {
  query2(tmdb_access_token: String!): api2Root
    @rest(
      endpoint: "https://api.themoviedb.org/3/person/1/movie_credits"
      headers: [{ name: "authorization", value: "Bearer $tmdb_access_token;" }]
    )
}

MODIFIED SCHEMA:

type Query {
  modified_query1(query: String, tmdb_access_token: String!): Api1ResultsEntry
    @rest(
      endpoint: "https://api.themoviedb.org/3/search/person"
      headers: [{ name: "authorization", value: "Bearer $tmdb_access_token;" }]
      resultroot: "results[]"
    )
}

type Query {
  modified_query2(id: Int! tmdb_access_token: String!): api2Root
    @rest(
      endpoint: "https://api.themoviedb.org/3/person/$id/movie_credits"
      headers: [{ name: "authorization", value: "Bearer $tmdb_access_token;" }]
    )
}

type Query {      
  sequence_query(query: String, tmdb_access_token: String!): api2Root
    @sequence(
        steps: [
                { query: "modified_query1", arguments: [{name: "query", argument: "query"}]}
                { query: "modified_query2", arguments: [{name: "tmdb_access_token", argument: "tmdb_access_token"}]}
            ]    
    )
}

EXAMPLE 2

ORIGINAL SCHEMA:

type Api1ResultsEntry {
  adult: Boolean
  backdrop_path: String
  genre_ids: [Int]
  id: Int
  original_language: String
  original_title: String
  overview: String
  popularity: Float
  poster_path: String
  release_date: String
  title: String
  video: Boolean
  vote_average: Float
  vote_count: Int
}

type api1Root {
  page: Int
  results: [Api1ResultsEntry]
  total_pages: Int
  total_results: Int
}

type Query {
  query1(query: String, tmdb_access_token: String!): api1Root
    @rest(
      endpoint: "https://api.themoviedb.org/3/search/movie"
      headers: [{ name: "authorization", value: "Bearer $tmdb_access_token;" }]
    )
}

type Api2CastEntry {
  adult: Boolean
  cast_id: Int
  character: String
  credit_id: String
  gender: Int
  id: Int
  known_for_department: String
  name: String
  order: Int
  original_name: String
  popularity: Float
  profile_path: String
}

type Api2CrewEntry {
  adult: Boolean
  credit_id: String
  department: String
  gender: Int
  id: Int
  job: String
  known_for_department: String
  name: String
  original_name: String
  popularity: Float
  profile_path: String
}

type api2Root {
  cast: [Api2CastEntry]
  crew: [Api2CrewEntry]
  id: Int
}

type Query {
  query2(tmdb_access_token: String!): api2Root
    @rest(
      endpoint: "https://api.themoviedb.org/3/movie/278/credits"
      headers: [{ name: "authorization", value: "Bearer $tmdb_access_token;" }]
    )
}

MODIFIED SCHEMA:

type Query {
  modified_query1(query: String, tmdb_access_token: String!): Api1ResultsEntry
    @rest(
      endpoint: "https://api.themoviedb.org/3/search/movie"
      headers: [{ name: "authorization", value: "Bearer $tmdb_access_token;" }]
      resultroot: "results[]"
    )
}

type Query {
  modified_query2(id: Int!, tmdb_access_token: String!): api2Root
    @rest(
      endpoint: "https://api.themoviedb.org/3/movie/$id/credits"
      headers: [{ name: "authorization", value: "Bearer $tmdb_access_token;" }]
    )
}

type Query {      
  sequence_query(query: String, tmdb_access_token: String!): api2Root
    @sequence(
        steps: [
                { query: "modified_query1", arguments: [{name: "query", argument: "query"}]}
                { query: "modified_query2", arguments: [{name: "tmdb_access_token", argument: "tmdb_access_token"}]}
            ]    
    )
}

EXAMPLE 3

ORIGINAL SCHEMA:

type Api1ResultsEntry {
  adult: Boolean
  backdrop_path: String
  genre_ids: [Int]
  id: Int
  original_language: String
  original_title: String
  overview: String
  popularity: Float
  poster_path: String
  release_date: Date
  title: String
  video: Boolean
  vote_average: Float
  vote_count: Int
}

type api1Root {
  page: Int
  results: [Api1ResultsEntry]
  total_pages: Int
  total_results: Int
}

type Query {
  query1(tmdb_access_token: String!): api1Root
    @rest(
      endpoint: "https://api.themoviedb.org/3/movie/top_rated"
      headers: [{ name: "authorization", value: "Bearer $tmdb_access_token;" }]
    )
}

type Api2CastEntry {
  adult: Boolean
  cast_id: Int
  character: String
  credit_id: String
  gender: Int
  id: Int
  known_for_department: String
  name: String
  order: Int
  original_name: String
  popularity: Float
  profile_path: String
}

type Api2CrewEntry {
  adult: Boolean
  credit_id: String
  department: String
  gender: Int
  id: Int
  job: String
  known_for_department: String
  name: String
  original_name: String
  popularity: Float
  profile_path: String
}

type api2Root {
  cast: [Api2CastEntry]
  crew: [Api2CrewEntry]
  id: Int
}

type Query {
  query2(tmdb_access_token: String!): api2Root
    @rest(
      endpoint: "https://api.themoviedb.org/3/movie/278/credits"
      headers: [{ name: "authorization", value: "Bearer $tmdb_access_token;" }]
    )
}

MODIFIED SCHEMA:

type Query {
  modified_query1(tmdb_access_token: String!): Api1ResultsEntry
    @rest(
      endpoint: "https://api.themoviedb.org/3/movie/top_rated"
      headers: [{ name: "authorization", value: "Bearer $tmdb_access_token;" }]
      resultroot: "results[]"
    )
}

type Query {
  modified_query2(id: Int!, tmdb_access_token: String!): api2Root
    @rest(
      endpoint: "https://api.themoviedb.org/3/movie/$id/credits"
      headers: [{ name: "authorization", value: "Bearer $tmdb_access_token;" }]
    )
}

type Query {      
  sequence_query(tmdb_access_token: String!): api2Root
    @sequence(
        steps: [
                { query: "modified_query1"}
                { query: "modified_query2", arguments: [{name: "tmdb_access_token", argument: "tmdb_access_token"}]}
            ]    
    )
}

EXAMPLE 4

ORIGINAL SCHEMA:
{{schema}}

MODIFIED SCHEMA:
"""

schemagen_prompt_spotify="""
You are a GraphQL expert. Given the following GraphQL schema, modify the schema to produce a new query type.
You should generate modified queries first and then a single sequence_query at the end.

EXAMPLE 1

ORIGINAL SCHEMA:

type Api1Actions {
  disallows: Api1Disallows
}

type Api1Album {
  album_type: String
  artists: [Api1ArtistsEntry]
  available_markets: [String]
  external_urls: Api1ExternalUrls2
  href: String
  id: String
  images: [Api1ImagesEntry]
  name: String
  release_date: Int
  release_date_precision: String
  total_tracks: Int
  type: String
  uri: String
}

type Api1Artists1Entry {
  external_urls: Api1ExternalUrls3
  href: String
  id: String
  name: String
  type: String
  uri: String
}

type Api1ArtistsEntry {
  external_urls: Api1ExternalUrls1
  href: String
  id: String
  name: String
  type: String
  uri: String
}

type Api1Context {
  external_urls: Api1ExternalUrls
  href: String
  type: String
  uri: String
}

type Api1Disallows {
  pausing: Boolean
  skipping_prev: Boolean
}

type Api1ExternalIds {
  isrc: String
}

type Api1ExternalUrls {
  spotify: String
}

type Api1ExternalUrls1 {
  spotify: String
}

type Api1ExternalUrls2 {
  spotify: String
}

type Api1ExternalUrls3 {
  spotify: String
}

type Api1ExternalUrls4 {
  spotify: String
}

type Api1ImagesEntry {
  height: Int
  url: String
  width: Int
}

type Api1Item {
  album: Api1Album
  artists: [Api1Artists1Entry]
  available_markets: [String]
  disc_number: Int
  duration_ms: Int
  explicit: Boolean
  external_ids: Api1ExternalIds
  external_urls: Api1ExternalUrls4
  href: String
  id: String
  is_local: Boolean
  name: String
  popularity: Int
  preview_url: String
  track_number: Int
  type: String
  uri: String
}

type api1Root {
  actions: Api1Actions
  context: Api1Context
  currently_playing_type: String
  is_playing: Boolean
  item: Api1Item
  progress_ms: Int
  timestamp: ID
}

type Query {
  query1(spotify_access_token: String!): api1Root
    @rest(
      endpoint: "https://api.spotify.com/v1/me/player/currently-playing"
      headers: [
        { name: "authorization", value: "Bearer $spotify_access_token;" }
      ]
    )
}

type Api2ExternalUrls {
  spotify: String
}

type Api2Followers {
  href: JSON
  total: Int
}

type Api2ImagesEntry {
  height: Int
  url: String
  width: Int
}

type api2Root {
  external_urls: Api2ExternalUrls
  followers: Api2Followers
  genres: [String]
  href: String
  id: String
  images: [Api2ImagesEntry]
  name: String
  popularity: Int
  type: String
  uri: String
}

type Query {
  query2(spotify_access_token: String!): api2Root
    @rest(
      endpoint: "https://api.spotify.com/v1/artists/04gDigrS5kc9YWfZHwBETP"
      headers: [
        { name: "authorization", value: "Bearer $spotify_access_token;" }
      ]
    )
}

MODIFIED SCHEMA:

type Query {
  modified_query1(q: String, spotify_access_token: String!, type: String): Api1ItemsEntry
    @rest(
      endpoint: "https://api.spotify.com/v1/search"
      headers: [
        { name: "authorization", value: "Bearer $spotify_access_token;" }
      ]
      resultroot: "artists.items[]"
    )
}

type Query {
  modified_query2(id:String!, spotify_access_token: String!): api2Root
    @rest(
      endpoint: "https://api.spotify.com/v1/artists/$id/albums"
      headers: [
        { name: "authorization", value: "Bearer $spotify_access_token;" }
      ]
    )
}

type Query {      
  sequence_query(q: String, spotify_access_token: String!, type: String): api2Root
    @sequence(
        steps: [
                { query: "modified_query1", arguments: [{name: "q", argument: "q"},{name: "type", argument: "type"}]}
                { query: "modified_query2", arguments: [{name: "spotify_access_token", argument: "spotify_access_token"}]}
            ]    
    )
}

EXAMPLE 2

ORIGINAL SCHEMA:

type Api1Artists {
  href: String
  items: [Api1ItemsEntry]
  limit: Int
  next: String
  offset: Int
  previous: JSON
  total: Int
}

type Api1ExternalUrls {
  spotify: String
}

type Api1Followers {
  href: JSON
  total: Int
}

type Api1ImagesEntry {
  height: Int
  url: String
  width: Int
}

type Api1ItemsEntry {
  external_urls: Api1ExternalUrls
  followers: Api1Followers
  genres: [String]
  href: String
  id: String
  images: [Api1ImagesEntry]
  name: String
  popularity: Int
  type: String
  uri: String
}

type api1Root {
  artists: Api1Artists
}

type Query {
  query1(q: String, spotify_access_token: String!, type: String): api1Root
    @rest(
      endpoint: "https://api.spotify.com/v1/search"
      headers: [
        { name: "authorization", value: "Bearer $spotify_access_token;" }
      ]
    )
}


type Api2ArtistsEntry {
  external_urls: Api2ExternalUrls1
  href: String
  id: String
  name: String
  type: String
  uri: String
}

type Api2ExternalUrls {
  spotify: String
}

type Api2ExternalUrls1 {
  spotify: String
}

type Api2ImagesEntry {
  height: Int
  url: String
  width: Int
}

type Api2ItemsEntry {
  album_group: String
  album_type: String
  artists: [Api2ArtistsEntry]
  available_markets: [String]
  external_urls: Api2ExternalUrls
  href: String
  id: String
  images: [Api2ImagesEntry]
  name: String
  release_date: String
  release_date_precision: String
  total_tracks: Int
  type: String
  uri: String
}

type api2Root {
  href: String
  items: [Api2ItemsEntry]
  limit: Int
  next: String
  offset: Int
  previous: JSON
  total: Int
}

type Query {
  query2(spotify_access_token: String!): api2Root
    @rest(
      endpoint: "https://api.spotify.com/v1/artists/04gDigrS5kc9YWfZHwBETP/albums"
      headers: [
        { name: "authorization", value: "Bearer $spotify_access_token;" }
      ]
    )
}

MODIFIED SCHEMA:

type Query {
  modified_query1(q: String, spotify_access_token: String!, type: String): Api1ItemsEntry
    @rest(
      endpoint: "https://api.spotify.com/v1/search"
      headers: [
        { name: "authorization", value: "Bearer $spotify_access_token;" }
      ]
      resultroot: "artists.items[]"
    )
}

type Query {
  modified_query2(id:String!, spotify_access_token: String!): api2Root
    @rest(
      endpoint: "https://api.spotify.com/v1/artists/$id/albums"
      headers: [
        { name: "authorization", value: "Bearer $spotify_access_token;" }
      ]
    )
}

type Query {      
  sequence_query(q: String, spotify_access_token: String!, type: String): api2Root
    @sequence(
        steps: [
                { query: "modified_query1", arguments: [{name: "q", argument: "q"},{name: "type", argument: "type"}]}
                { query: "modified_query2", arguments: [{name: "spotify_access_token", argument: "spotify_access_token"}]}
            ]    
    )
}

EXAMPLE 3

ORIGINAL SCHEMA:

type Api1ExternalUrls {
  spotify: String
}

type Api1ExternalUrls1 {
  spotify: String
}

type Api1ImagesEntry {
  height: JSON
  url: String
  width: JSON
}

type Api1ItemsEntry {
  collaborative: Boolean
  description: String
  external_urls: Api1ExternalUrls
  href: String
  id: String
  images: [Api1ImagesEntry]
  name: String
  owner: Api1Owner
  primary_color: JSON
  public: Boolean
  snapshot_id: String
  tracks: Api1Tracks
  type: String
  uri: String
}

type Api1Owner {
  display_name: String
  external_urls: Api1ExternalUrls1
  href: String
  id: String
  type: String
  uri: String
}

type Api1Tracks {
  href: String
  total: Int
}

type api1Root {
  href: String
  items: [Api1ItemsEntry]
  limit: Int
  next: JSON
  offset: Int
  previous: JSON
  total: Int
}

type Query {
  query1(spotify_access_token: String!): api1Root
    @rest(
      endpoint: "https://api.spotify.com/v1/me/playlists"
      headers: [
        { name: "authorization", value: "Bearer $spotify_access_token;" }
      ]
    )
}

type Api2AddedBy {
  external_urls: Api2ExternalUrls
  href: String
  id: String
  type: String
  uri: String
}

type Api2Album {
  album_type: String
  artists: [Api2ArtistsEntry]
  available_markets: [String]
  external_urls: Api2ExternalUrls2
  href: String
  id: String
  images: [Api2ImagesEntry]
  name: String
  release_date: Int
  release_date_precision: String
  total_tracks: Int
  type: String
  uri: String
}

type Api2Artists1Entry {
  external_urls: Api2ExternalUrls3
  href: String
  id: String
  name: String
  type: String
  uri: String
}

type Api2ArtistsEntry {
  external_urls: Api2ExternalUrls1
  href: String
  id: String
  name: String
  type: String
  uri: String
}

type Api2ExternalIds {
  isrc: String
}

type Api2ExternalUrls {
  spotify: String
}

type Api2ExternalUrls1 {
  spotify: String
}

type Api2ExternalUrls2 {
  spotify: String
}

type Api2ExternalUrls3 {
  spotify: String
}

type Api2ExternalUrls4 {
  spotify: String
}

type Api2ImagesEntry {
  height: Int
  url: String
  width: Int
}

type Api2ItemsEntry {
  added_at: DateTime
  added_by: Api2AddedBy
  is_local: Boolean
  primary_color: JSON
  track: Api2Track
  video_thumbnail: Api2VideoThumbnail
}

type Api2Track {
  album: Api2Album
  artists: [Api2Artists1Entry]
  available_markets: [String]
  disc_number: Int
  duration_ms: Int
  episode: Boolean
  explicit: Boolean
  external_ids: Api2ExternalIds
  external_urls: Api2ExternalUrls4
  href: String
  id: String
  is_local: Boolean
  name: String
  popularity: Int
  preview_url: String
  track: Boolean
  track_number: Int
  type: String
  uri: String
}

type Api2VideoThumbnail {
  url: JSON
}

type api2Root {
  href: String
  items: [Api2ItemsEntry]
  limit: Int
  next: JSON
  offset: Int
  previous: JSON
  total: Int
}

type Query {
  query2(spotify_access_token: String!): api2Root
    @rest(
      endpoint: "https://api.spotify.com/v1/playlists/7olxsIPAL7TGVN9HC89DNP/tracks"
      headers: [
        { name: "authorization", value: "Bearer $spotify_access_token;" }
      ]
    )
}

MODIFIED SCHEMA:

type Query {
  modified_query1(spotify_access_token: String!): Api1ItemsEntry
    @rest(
      endpoint: "https://api.spotify.com/v1/me/playlists"
      headers: [
        { name: "authorization", value: "Bearer $spotify_access_token;" }
      ]
      resultroot: "items[]"
    )
}

type Query {
  modified_query2(id: String!, spotify_access_token: String!): api2Root
    @rest(
      endpoint: "https://api.spotify.com/v1/playlists/$id/tracks"
      headers: [
        { name: "authorization", value: "Bearer $spotify_access_token;" }
      ]
    )
}

type Query {      
  sequence_query(spotify_access_token: String!): api2Root
    @sequence(
        steps: [
                { query: "modified_query1"}
                { query: "modified_query2", arguments: [{name: "spotify_access_token", argument: "spotify_access_token"}]}
            ]    
    )
}

EXAMPLE 4

ORIGINAL SCHEMA:
{{schema}}

MODIFIED SCHEMA:
"""

def get_bam_response_graphql(prompt, model_id):
    load_dotenv()
    credentials = Credentials.from_env()
    parameters = TextGenerationParameters(decoding_method="greedy", max_new_tokens=400, temperature=0.05, stop_sequences=["EXAMPLE"], include_stop_sequence=False)
    client = Client(credentials=credentials)
    responses = list(
        client.text.generation.create(
            model_id=model_id,
            inputs=[prompt],
            parameters=parameters,
        )
    )
    return responses[0].results[0].generated_text

def get_modified_schema_tmdb(working_dir, model_id="ibm/granite-20b-code-instruct-v2"):
    dirs = [f for f in os.listdir(working_dir) if os.path.isdir(os.path.join(working_dir, f))]
    schema = ""
    for dir in dirs:
        fname = os.path.join(working_dir, dir, "index.graphql")
        with open(fname) as f:
            schema += f.read()

    prompt = schemagen_prompt_tmdb.replace("{{schema}}", schema)
    response = get_bam_response_graphql(prompt, model_id)
    output = response.strip()
    return output

def get_modified_schema_spotify(working_dir, model_id="ibm/granite-20b-code-instruct-v2"):
    dirs = [f for f in os.listdir(working_dir) if os.path.isdir(os.path.join(working_dir, f))]
    schema = ""
    for dir in dirs:
        fname = os.path.join(working_dir, dir, "index.graphql")
        with open(fname) as f:
            schema += f.read()

    prompt = schemagen_prompt_spotify.replace("{{schema}}", schema)
    response = get_bam_response_graphql(prompt, model_id)
    output = response.strip()
    return output
