#SEM

#marginal effects
#movie$length <- as.factor(movie$length)
l20 <- c(1,0)    #20items = 1, 5items = 0
movie$l20 <- ifelse(movie$length == "20 items", 1, 0)


#movie$diversification <- as.factor(movie$diversification)

movie$divmedium <- ifelse(movie$diversification == "medium", 1, 0)
movie$divhigh <- ifelse(movie$diversification == "high", 1, 0)

movie$l20medium <- movie$l20 * movie$divmedium
movie$l20high <- movie$l20 * movie$divhigh


model <-'div =~ div1+div2+div3+div5
acc =~ acc1+acc2+acc3+acc5
sat =~ sat1+sat2+sat3+sat4
diff =~ diff4+diff5
div ~ rd0*l20 + rd1*divmedium + rd2*divhigh + rd3*l20medium + rd4*l20high'
fit <- sem(model, data=movie, ordered = names(movie[3:29]), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)
lavTestWald(fit, "rd3 == 0; rd4 == 0")
lavTestWald(fit, "rd1 == 0; rd2 == 0")

m1 <-'div =~ div1+div2+div3+div5
acc =~ acc1+acc2+acc3+acc5
sat =~ sat1+sat2+sat3+sat4
diff =~ diff4+diff5
acc ~ ra0*l20 + ra1*divmedium + ra2*divhigh + ra3*l20medium + ra4*l20high'
fit <- sem(m1, data=movie, ordered = names(movie[3:29]), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)
lavTestWald(fit, "ra3 == 0; ra4 == 0")
lavTestWald(fit, "ra1 == 0; ra2 == 0")

m2 <-'div =~ div1+div2+div3+div5
acc =~ acc1+acc2+acc3+acc5
sat =~ sat1+sat2+sat3+sat4
diff =~ diff4+diff5
diff ~ cd0*l20 + cd1*divmedium + cd2*divhigh + cd3*l20medium + cd4*l20high'
fit <- sem(m2, data=movie, ordered = names(movie[3:29]), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)
lavTestWald(fit, "cd3 == 0; cd4 == 0")
lavTestWald(fit, "cd1 == 0; cd2 == 0")

m3 <-'div =~ div1+div2+div3+div5
acc =~ acc1+acc2+acc3+acc5
sat =~ sat1+sat2+sat3+sat4
diff =~ diff4+diff5
sat ~ cs0*l20 + cs1*divmedium + cs2*divhigh + cs3*l20medium + cs4*l20high'
fit <- sem(m3, data=movie, ordered = names(movie[3:29]), std.lv = TRUE)
summary(fit, rsquare = TRUE, fit.measures = TRUE)
lavTestWald(fit, "cs3 == 0; cs4 == 0")
lavTestWald(fit, "cs1 == 0; cs2 == 0")

m_causal_ordered <-'div =~ div1+div2+div3+div5
acc =~ acc1+acc2+acc3+acc5
diff =~ diff4+diff5
sat =~ sat1+sat2+sat3+sat4
sat ~ diff+acc+div+cs0*l20+cs1*divmedium+cs2*divhigh
diff ~ acc+div+cd0*l20+cd1*divmedium+cd2*divhigh
acc ~ div+ra0*l20+ra1*divmedium+ra2*divhigh
div ~ rd0*l20+rd1*divmedium+rd2*divhigh'
fit <- sem(m_causal_ordered, data=movie, ordered = names(movie[3:29]), std.lv = TRUE)
summary(fit)

m1_causal_ordered <-'div =~ div1+div2+div3+div5
acc =~ acc1+acc2+acc3+acc5
diff =~ diff4+diff5
sat =~ sat1+sat2+sat3+sat4
sat ~ diff+acc
diff ~ acc+cd1*divmedium+cd2*divhigh
acc ~ div
div ~ rd1*divmedium+rd2*divhigh'
fit <- sem(m1_causal_ordered, data=movie, ordered = names(movie[3:29]), std.lv = TRUE)
summary(fit)

mfinal_causal_ordered <-'div =~ div1+div2+div3+div5
acc =~ acc1+acc2+acc3+acc5
diff =~ diff4+diff5
sat =~ sat1+sat2+sat3+sat4
sat ~ diff+acc
diff ~ acc+cd1*divmedium+cd2*divhigh
acc ~ div
div ~ rd1*divmedium+rd2*divhigh'
fit <- sem(mfinal_causal_ordered, data=movie, ordered = names(movie[3:29]), std.lv = TRUE)
summary(fit)
summary(fit, rsquare = TRUE, fit.measures = TRUE)
lavTestWald(fit, "rd1 == 0; rd2 == 0")
lavTestWald(fit, "cd1 == 0; cd2 == 0")

mods <- modindices(fit)
mods
mods <- mods[grep("\\*", mods$decision),]
mods

