# 8월 버전입니다. 추후 사용할 때 수정할 예정입니다.
def t_interval3(column: NumColumn) -> Block:
    res_column = column.normalize(type=NormType.ZERO_ONE)

    block_sum = sum(res_column)
    block_count = count(column)
    block_count_minus = block_count - 1
    block_count_inv = __safe_inverse(block_count, column.num_rows)
    block_avg = block_sum * block_count_inv

    block_k = Block.zeros(column.context, encrypted=True)
    if column.has_vbit():
        for data_block, vbit_block in zip(res_column.data, res_column.vbit):
            tmp = data_block - block_avg
            tmp *= vbit_block
            tmp *= tmp
            block_k += tmp
    else:
        for data_block in zip(column.data):
            tmp = data_block - block_avg
            tmp *= tmp
            block_k += tmp
    block_k = __rotate_sum(block_k)
    block_count_minus_inv = __safe_inverse(block_count_minus, column.num_rows)
    block_k *= block_count_minus_inv
    # block_k is variance

    if block_k.need_bootstrap(6):
        block_k.bootstrap(one_slot=True)
    block_k = block_k.sqrt(one_slot=True)
    # block_k is std

    block_count_normalized = block_count * (1 / column.num_rows)  # Normalizing n and finding sqrt_inv(n)
    if block_count_normalized.need_bootstrap():
        block_count_normalized.bootstrap(one_slot=True)
    block_sqrtinv_n = block_count_normalized.sqrt_inv(one_slot=True)
    block_sqrtinv_n *= column.num_rows ** (-0.5)

    if block_sqrtinv_n.need_bootstrap(6):
        block_sqrtinv_n.bootstrap(one_slot=True)
    if block_k.need_bootstrap(6):
        block_k.bootstrap(one_slot=True)
    block_k *= block_sqrtinv_n  # Dividing by sqrt(n)

    block_k *= column.range  # Undoing normalization

    return block_k


def proportion_confint(column: NumColumn, alpha: float = 0.05, method: str = "normal") -> Block:

    from scipy.stats import norm

    z = norm.ppf(alpha / 2)

    if method == "normal":

        # version 1
        """block_count = count(column)
        block_count_inv = __safe_inverse(block_count, column.num_rows)

        block_sum = sum(column)
        mean_block = block_sum * block_count_inv
        se_block = mean_block * (Block.ones(column.context, encrypted=True) - mean_block)
        se_block *= block_count_inv
        se_block = se_block.sqrt()"""

        # version 2
        block_count = count(column)

        block_count_resize = block_count * (1 / column.num_rows)
        block_count_resize_sqrt_inv = block_count_resize.sqrt_inv()
        block_count_sqrt_inv = block_count_resize_sqrt_inv * (1 / math.sqrt(column.num_rows))

        block_sum = sum(column)
        block_count_inv = __safe_inverse(block_count, column.num_rows)

        mean_block = block_sum * block_count_inv

        se_block = mean_block * (Block.ones(column.context, encrypted=True) - mean_block)
        se_block.bootstrap(one_slot=True)

        se_block = se_block.sqrt()
        se_block.bootstrap(one_slot=True)

        se_block *= block_count_sqrt_inv
        return mean_block, se_block

    if method == "agresti_coull":

        # version 1
        """block_count = count(column)
        block_count += z ** 2
        block_count_inv = __safe_inverse(block_count, column.num_rows)

        block_sum = sum(column)
        mean_block = (block_sum + z ** 2 / 2) * block_count_inv
        se_block = mean_block * (Block.ones(column.context, encrypted=True) - mean_block)
        se_block *= block_count_inv
        se_block = se_block.sqrt()"""

        # version 2
        block_count = count(column)
        block_count += z ** 2

        block_sum = sum(column)
        block_count_inv = __safe_inverse(block_count, column.num_rows)

        mean_block = (block_sum + z ** 2 / 2) * block_count_inv

        block_count_resize = block_count * (1 / column.num_rows)
        block_count_resize_sqrt_inv = block_count_resize.sqrt_inv()
        block_count_sqrt_inv = block_count_resize_sqrt_inv * (1 / math.sqrt(column.num_rows))

        se_block = mean_block * (Block.ones(column.context, encrypted=True) - mean_block)
        se_block.bootstrap(one_slot=True)

        se_block = se_block.sqrt()
        se_block.bootstrap(one_slot=True)

        se_block *= block_count_sqrt_inv
        return mean_block, se_block
