# baseline ALBERT model
export TASK_NAME=logiqa
export MODEL_NAME=albert-xxlarge-v2
export LOGIQA_DIR=../../logiqa-data

deepspeed --num_gpus=2 train_logi.py \
    --model_type albert \
    --model_name_or_path $MODEL_NAME \
    --task_name $TASK_NAME \
    --data_dir $LOGIQA_DIR \
    --do_lower_case \
    --do_train \
    --do_eval \
    --max_seq_length 256 \
    --learning_rate 1e-5 \
    --num_train_epochs 10.0 \
    --per_gpu_eval_batch_size 4  \
    --per_gpu_train_batch_size 4  \
    --gradient_accumulation_steps 2  \
    --overwrite_cache \
    --pad_to_max_length \
    --logging_steps 20 \
    --save_steps 200 \
    --fp16 \
    --output_dir ../../Checkpoints/$TASK_NAME/albert-xxlarge-v2_ds_lr1_256_e10 \
    --run_name albert_xxlarge_v2_ds_lr1_256_e10 \
    --label_smoothing_factor 0.1 \
    --do_test \



