# encoding=utf-8
import os
cwd = os.getcwd()


class HyperParam:
    def __init__(self, mode, gpu=0, vocab=25000):
        self.gpu = gpu

        self.vocabulary_type = 'word'
        self.vocabulary_size = vocab
        self.general_path = None

        if mode == 'debug':
            self.debug()
        else:
            raise NameError("choose the right mode.")

    def _print_items(self):
        print('\n'.join(['%s:%s' % item for item in self.__dict__.items()]))

    def debug(
        self,
        batch_size=32,
        bert_size=768,
        buffer_size=3200,
        d_word_vec=512,
        d_model=512,
        vae_size=128,
        d_inner_hid=2024,
        max_len=256,
        lr=2e-5,
        trainsets_len=1,
        lambda_edit=1,
        label_smoothing=0.1,
        use_feature=False,
        use_bucket=True,
        shuffle=True,
        proj_share_weight=True,
        bridge_type='mlp',
        batching_key='samples',
        schedule_method='loss',
        finetune=True,
        warmup_steps=5000,
        update_cycle=1,
        dropout=0.1,
        src_drop=0.2,
        valid_freq=500,
        valid_threshold=1400,
        optim='adam',
    ):
        self.batch_size = batch_size
        self.buffer_size = batch_size * 10

        self.bert_size = bert_size
        self.d_word_vec = d_word_vec
        self.d_model = d_model
        self.vae_size = vae_size
        self.d_inner_hid = d_inner_hid
        self.max_len = max_len
        self.lr = lr
        self.trainsets_len = trainsets_len
        self.lambda_edit = lambda_edit
        self.dropout = dropout
        self.src_drop = src_drop
        self.valid_freq = valid_freq
        self.valid_threshold = valid_threshold

        self.optim = optim

        self.label_smoothing = label_smoothing
        self.use_feature=use_feature
        self.use_bucket = use_bucket
        self.shuffle = shuffle
        self.proj_share_weight = proj_share_weight
        self.batching_key = batching_key
        self.schedule_method = schedule_method
        self.finetune = finetune
        self.warmup_steps = warmup_steps
        self.bridge_type = bridge_type
        self.update_cycle = update_cycle

        self.label_vocab = 'xxx'
        self.bert_path = 'xxx'
        self.pos_path = None

        self.train_data = ['xxx']
        self.dev_data = 'xxx'
        self.test_data = 'xxx'

        self.trie_path = 'xxx'

        self.use_zen = False
        self.use_lexicon = False

        self.lexicon_embedding_path = 'xxx'
        self.lexicon_vocab_path = 'xxx'
        self.max_scan_num = 7500000
        self.max_lexicon_word_num = 15
        self.saved_lexicon_embedding_dir = 'xxx'

        self.train_json = 'xxx'
        self.dev_json = 'xxx'
        self.test_json = 'xxx'
