import argparse
import pathlib
import re
import shutil

parser = argparse.ArgumentParser()
parser.add_argument('--workspaces', nargs='+', type=pathlib.Path, required=True)


classification_method_re = re.compile(r'^CLASSIFICATION_METHOD\s*=')

def process_workspace(args, workspace):
    # Edit configuration file
    lines = (workspace / 'conf' / 'conf.py').read_text().splitlines()
    matched_lineno = -1
    for i, line in enumerate(lines):
        m = classification_method_re.match(line)
        if m:
            matched_lineno = i
    if matched_lineno != -1:
        lines[matched_lineno] = 'CLASSIFICATION_METHOD = \'svm\''
    else:
        lines.append('CLASSIFICATION_METHOD = \'svm\'')
    with open(workspace / 'conf' / 'conf.py', 'w') as f:
        for line in lines:
            print(line, file=f)

    # Save classififier configuration
    p = workspace / 'conf' / f'svm.py'
    with open(p, 'w') as f:
        print('KEYWORDS = {', file=f)
        print('}', file=f)
    shutil.copy(p, workspace / 'conf' / 'classifier_hyperparams.py')


def run(args):
    for workspace in args.workspaces:
        process_workspace(args, workspace)


if __name__ == '__main__':
    args = parser.parse_args()
    run(args)
