from textblob_de import TextBlobDE as TextBlob
import random

noun = 0.48
adjective = 0.079
DT = 0.142
CD = 0.056
verb = 0.096
preposition = 0.156
interjection = 0.129
adverb = 0.029
pronoun = 0.013
conjunction = 0.143
f1_original = 65
line_number = 0


def return_labels(pos_tags, f1, ground_truth_annotations):
    final_tag = []
    count = 0
    f1_final = f1_original/f1
    for j in range(1, len(pos_tags)):
        if pos_tags[j] == 'DT' or pos_tags[j] == 'WDT':
            number = DT * f1_final
            if number > random.random():
                if ground_truth_annotations[line_number-1][2*j] == 'OK':
                    final_tag.append(random.randrange(4,7))
                else:
                    final_tag.append(random.randrange(1,4))
            else:
                final_tag.append(ground_truth_annotations[line_number-1][2*j])

        elif pos_tags[j] == 'VB' or pos_tags[j] == 'VBN' or pos_tags[j] == 'VBD':
            number = verb * f1_final
            if number > random.random():
                if ground_truth_annotations[line_number-1][2*j] == 'OK':
                    final_tag.append(random.randrange(4,7))
                else:
                    final_tag.append(random.randrange(1,4))
            else:
                final_tag.append(ground_truth_annotations[line_number-1][2*j])

        elif pos_tags[j] == 'IN':
            number = (interjection * f1_final + preposition * f1_final)/2
            if number > random.random():
                if ground_truth_annotations[line_number-1][2 * j] == 'OK':
                    final_tag.append(random.randrange(4,7))
                else:
                    final_tag.append(random.randrange(1,4))
            else:
                final_tag.append(ground_truth_annotations[line_number-1][2 * j])

        elif pos_tags[j] == 'TO':
            number = (preposition * f1_final + adverb * f1_final) / 2
            if number > random.random():
                if ground_truth_annotations[line_number - 1][2 * j] == 'OK':
                    final_tag.append(random.randrange(4,7))
                else:
                    final_tag.append(random.randrange(1,4))
            else:
                final_tag.append(ground_truth_annotations[line_number - 1][2 * j])

        elif pos_tags[j] == 'NN' or pos_tags[j] == 'NNP' or pos_tags[j] == 'NNS':
            number = noun * f1_final
            if number > random.random():
                if ground_truth_annotations[line_number-1][2 * j] == 'OK':
                    final_tag.append(random.randrange(4,7))
                else:
                    final_tag.append(random.randrange(1,4))
            else:
                final_tag.append(ground_truth_annotations[line_number-1][2 * j])

        elif pos_tags[j] == 'JJ':
            number = adjective * f1_final
            if number > random.random():
                if ground_truth_annotations[line_number-1][2 * j] == 'OK':
                    final_tag.append(random.randrange(4,7))
                else:
                    final_tag.append(random.randrange(1,4))
            else:
                final_tag.append(ground_truth_annotations[line_number-1][2 * j])

        elif pos_tags[j] == 'PRP' or pos_tags[j] == 'PRP$':
            number = pronoun * f1_final
            if number > random.random():
                if ground_truth_annotations[line_number-1][2 * j] == 'OK':
                    final_tag.append(random.randrange(4,7))
                else:
                    final_tag.append(random.randrange(1,4))
            else:
                final_tag.append(ground_truth_annotations[line_number-1][2 * j])

        elif pos_tags[j] == 'CC':
            number = conjunction * f1_final
            if number > random.random():
                if ground_truth_annotations[line_number-1][2 * j] == 'OK':
                    final_tag.append(random.randrange(4,7))
                else:
                    final_tag.append(random.randrange(1,4))
            else:
                final_tag.append(ground_truth_annotations[line_number-1][2 * j])

        elif pos_tags[j] == 'RB' or pos_tags[j] == 'WRB' or pos_tags[j] == 'RP':
            number = adverb * f1_final
            if number > random.random():
                if ground_truth_annotations[line_number-1][2 * j] == 'OK':
                    final_tag.append(random.randrange(4,7))
                else:
                    final_tag.append(random.randrange(1,4))
            else:
                final_tag.append(ground_truth_annotations[line_number-1][2 * j])

        else:
            number = CD * f1_final
            if number > random.random():
                if ground_truth_annotations[line_number - 1][2 * j] == 'OK':
                    final_tag.append(random.randrange(4,7))
                else:
                    final_tag.append(random.randrange(1,4))
            else:
                final_tag.append(ground_truth_annotations[line_number - 1][2 * j])
    return final_tag


file_pointer = open("machine_translation.txt", "r")
ground_truth_array = []
with open('ground_truth_annotations.txt') as my_file:
    for labels in my_file:
        ground_truth_array.append(labels.split())

lines = file_pointer.readlines()

for line in lines:
    line_number += 1
    f = open("resultProj_65.txt", "a")
    text = line
    blob = TextBlob(text)
    POSTags = []

    for i in range(0, len(blob.tags)):
        POSTags.append(blob.tags[i][1])

    finalTags = return_labels(POSTags, 65, ground_truth_array)
    finalTupleSet = []
    for i in range(0, len(finalTags)):
        tuple_ = finalTags[i]
        finalTupleSet.append(tuple_)
    f.write(str(finalTupleSet)+'\n')
    f.close()