import React, { Component } from 'react';
import { Random } from 'meteor/random'

import { gup } from '../util/gup.js';

function getClusterWithMention(clusters, mention) {
  return clusters.find(cluster => {
    return cluster.mentions.some(other => {
      return other.start == mention.start && other.end == mention.end;
    });
  });
}

function getMatchingMention(start, end, label, clusters) {
  const options = clusters.map(cluster => {
    return cluster.mentions.filter(mention => {
      return mention.start == start && mention.end == end && mention.label == label;
    });
  }).filter(mentions => mentions.length > 0);
  if (options.length > 0) return options[0][0];
  else return null;
}

export default class SentimentSlider extends Component {
  constructor(props) {
    super(props);

    this.state = {
      edited: false,
      sentiment: 12,
      user: gup("workerId"),
    };

    this.handleInputChange = this.handleInputChange.bind(this);
    this.mouseUp = this.mouseUp.bind(this);
    this.updateLabel = this.updateLabel.bind(this);
    this.createClusterFromMention = this.createClusterFromMention.bind(this);
    this.removeMention = this.removeMention.bind(this);
    this.removeCluster = this.removeCluster.bind(this);
  }

  createClusterFromMention(start, end, color, label="") {
    const cluster = {
      _id: Random.id(),
      mentions: [{start: start, end:end, label:label}],
      color: color != null ? color : this.state.availableColors[0],
    };
    if (color == null && this.state.availableColors.length > 1) {
      const remainingColors = this.state.availableColors.slice(1);
      this.setState({
        availableColors: remainingColors,
      });
    }
    Meteor.call('clusters.insert', this.props.text._id, this.props.ann_id, cluster, this.state.user);
  }

  removeCluster(cluster) {
    Meteor.call('clusters.remove', this.props.text._id, this.props.ann_id, cluster._id, cluster.mentions, this.state.user);
  }

  removeMention(cluster, mention) {
    if (cluster.mentions.length == 1) {
      this.removeCluster(cluster);
    } else {
      Meteor.call('clusters.contract', this.props.text._id, this.props.ann_id, cluster._id, mention.start, mention.end, mention.label, this.state.user);
    }
  }

  updateLabel(sentiment) {
    if (this.props.readOnly) return;

    const mention = {
      start: this.props.sentimentTaskNum,
      end: this.props.sentimentTaskNum,
      label: sentiment
    };
    const target = getMatchingMention(mention.start, mention.end, mention.label, this.props.clusters);
    const cluster = getClusterWithMention(this.props.clusters, mention);
    if (target == null) {
      this.createClusterFromMention(mention.start, mention.end, "", sentiment);
      this.removeMention(cluster, mention);
    }
  }

  handleInputChange(event) {
    if (this.props.readOnly) return;
    this.props.updateValue(this.props.sentimentTaskNum);

    const target = event.target;
    const value = target.value;
    const name = target.name;

    this.setState({
      edited: true,
      [name]: value
    });
    this.updateLabel(value.toString());
  }

  mouseUp() {
    if (this.props.readOnly) return;
    this.props.updateValue(this.props.sentimentTaskNum);
    this.updateLabel(this.state.sentiment.toString());

    this.setState({
      edited: true,
    });
  }

  render() {
    const mainStyle = this.state.edited ? "sentiment-edited" : "" ;
    return (
      <div className={mainStyle}>
        <div className="sentiment-example">
          {this.props.example}
        </div>

        <div className="rangeq">
          <input
            name="sentiment"
            type="range"
            min="0"
            max="25"
            value={this.state.sentiment}
            onChange={this.handleInputChange}
            onMouseUp={this.mouseUp}
            orient="vertical"
            step="1"/>
        </div>
        <div className="rangel">
          <ul>
            <li className="rangelabel">Very negative</li>
            <li className="rangelabel">Negative</li>
            <li className="rangelabel">Somewhat negative</li>
            <li className="rangelabel">Neutral</li>
            <li className="rangelabel">Somewhat positive</li>
            <li className="rangelabel">Positive</li>
            <li className="rangelabel">Very positive</li>
          </ul>
        </div>
      </div>
    );
  }
}

