UKP Covid-19 Twitter Corpus
-------------------------------------

The UKP Covid-19 Twitter Corpus includes 2,785 tweets 
annotated by student annotators and 200 expert-annotated tweets
in German.
Each tweet was annotated as either a supporting opinion ("Support"), 
an attacking argument ("Refute"), a commenting statement ("Comment")
or unrelated ("Unrelated") with respect to governmental measures 
taken to prevent the spread of Covid-19.

The student annotation file ("studentdata.csv") includes the following
information:

* id_str: the official Tweet ID

* studentannotation: the annotation provided by the respective 
student annotator

* recommendation: the label suggestion provided by the model

* annotation_id: the annotation round (see paper for details)

* user_id: the student annotator identification (anonymized)

* group_id: the student annotator group

The expert annotation file ("expertdata.csv") includes the following 
information:

* id_str: the official Tweet ID

* label: the annotation provided by the expert annotators


Due to possible copyright issues, the released data does not include 
the full text field. For retrieving the full text, you can use
the tool we provide ("retrieval.py") which enables the retrieval of
Tweet information when providing the Tweet ID. To use it, you need 
to update the script with your Twitter API keys (consumer_key, 
consumer_secret, access_token, access_token_secret). Then, simply call

`python retrieval.py`

It will retrieve the full_text for the data file provided
(default: `studentdata.csv`) and write the complemented data
to a new file (default: `studentdata_retrieved.tsv`).

Further, we provide the original annotation guidelines 
in German in the "guidelines.pdf" file.