'''
ontology for exteneded-bAbI
'''
ONTO = {
    'restaurants': {
        "food": ["french","british","italian","spanish","indian"],
        "location": ["madrid","paris","bombay","rome","london"],
        "people": ["eight","two","six","four"],
        "price": ["cheap","expensive","moderate"],
        "address": None,
        "phone number": None,
        "rating":None
    },
    'hotels': {
        "checkin": ["monday","tuesday","wednesday", "thursday"],
        "checkout": ["friday","saturday","sunday"],
        "location": ["paris","beijing","rome","london"],
        "room": ["one","two", "three"],
        "price": ["cheap","expensive","moderate"],
        "address": None,
        "phone number": None,
        "price per night": None,
        "rating": None
    },
    'travels': {
        "category": ["museums", "natural sites", "historic sites", "malls"],
        "country": ["american", "england", "china", "japan", "india", "europe"],
        "free entry": None,
        "attraction name": None,
        "address": None
    },
    'movies': {
        "director": ["cameron", "nolan", "spielberg"],
        "actor": ["leonardo", "schwarzenegger", "liam"],
        "category": ["action", "comedy", "thriller", "fiction", "war"],
        "free": None,
        "length": None,
        "cast": None,
        "introduction": None
    },
    "music": {
        "singer": ["jaychou", "taylor", "adele", "mars", "mj"],
        "category": ["rock", "country", "rap", "romantic", "pop"],
        "release year": None,
        "album": None,
        "rating": None
    },
    "buses":{
        "from": ["beijing", "shanghai"],
        "to": ["guangzhou", "hangzhou"],
        "leaving date": ["monday","tuesday","wednesday","thursday","friday"],
        "ticket": ["one","two"],
        "fare": None,
        "address": None
    },
    "flights":{
        "from": ["beijing", "shanghai"],
        "to": ["paris", "london"],
        "leaving date": ["monday","tuesday","wednesday","thursday","friday", "saturday","sunday"],
        "ticket": ["one","two"],
        "fare": None,
        "airport": None
    },
    "weather":{
        "location":["beijing", "shanghai", "guangzhou", "hangzhou", "madrid", "paris", "bombay", "rome", "london"],
        "date": ["today", "tomorrow"]
    }
}

PARAMS = {
    'restaurants': {
        'maxnum_req_slots': 2,
        'slot_update_ratio': (0.3, 1.5, 3.5, 3, 1),
        'entity_update_ratio': (1, 4, 4.5, 1.5, 1, 0.3)
    },
    'hotels': {
        'maxnum_req_slots': 3,
        'slot_update_ratio': (0.3, 3, 3, 0.5, 0.5),
        'entity_update_ratio': (1, 4, 4.5, 0.5, 0.5, 0.2)
    },
    'travels': {
        'maxnum_req_slots': 2,
        'slot_update_ratio': (1, 10, 1, 1),
        'entity_update_ratio': (1, 4, 3, 0.5)
    },
    'movies': {
        'maxnum_req_slots': 3,
        'slot_update_ratio': (0.5, 2, 2, 1),
        'entity_update_ratio': (1, 2, 1)
    },
    'music': {
        'maxnum_req_slots': 2,
        'slot_update_ratio': (1, 2),
        'entity_update_ratio': (0.2, 2, 4, 4, 2, 1)
    },
    'buses': {
        'maxnum_req_slots': 1,
        'slot_update_ratio': (1, 2, 4, 5),
        'entity_update_ratio': (1, 2)
    },
    'flights': {
        'maxnum_req_slots': 1,
        'slot_update_ratio': (1, 3, 4, 4),
        'entity_update_ratio': (1, 2)
    },
    'weather': {
        'maxnum_req_slots': 0,
        'slot_update_ratio': (2, 2, 1),
        'entity_update_ratio': (1,)
    },


}
