/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.TwoDimensionalMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ThreeDimensionalMap<K1, K2, K3, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    Map<K1, TwoDimensionalMap<K2, K3, V>> map = Generics.newHashMap();

    public int size() {
        int size = 0;
        for (Map.Entry<K1, TwoDimensionalMap<K2, K3, V>> entry : this.map.entrySet()) {
            size += entry.getValue().size();
        }
        return size;
    }

    public boolean isEmpty() {
        for (Map.Entry<K1, TwoDimensionalMap<K2, K3, V>> entry : this.map.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public V put(K1 key1, K2 key2, K3 key3, V value) {
        TwoDimensionalMap<K3, K3, V> m = this.getTwoDimensionalMap(key1);
        return m.put(key2, key3, value);
    }

    public V get(K1 key1, K2 key2, K3 key3) {
        return this.getTwoDimensionalMap(key1).get(key2, key3);
    }

    public boolean contains(K1 key1, K2 key2, K3 key3) {
        if (!this.map.containsKey(key1)) {
            return false;
        }
        if (!this.map.get(key1).containsKey(key2)) {
            return false;
        }
        return this.map.get(key1).get(key2).containsKey(key3);
    }

    public void remove(K1 key1, K2 key2, K3 key3) {
        this.get(key1, key2).remove(key3);
    }

    public Map<K3, V> get(K1 key1, K2 key2) {
        return this.get(key1).get(key2);
    }

    public TwoDimensionalMap<K2, K3, V> get(K1 key1) {
        return this.getTwoDimensionalMap(key1);
    }

    public TwoDimensionalMap<K2, K3, V> getTwoDimensionalMap(K1 key1) {
        TwoDimensionalMap<Object, Object, V> m = this.map.get(key1);
        if (m == null) {
            m = new TwoDimensionalMap();
            this.map.put(key1, m);
        }
        return m;
    }

    public Collection<V> values() {
        ArrayList<V> s = Generics.newArrayList();
        for (TwoDimensionalMap<K2, K3, V> innerMap : this.map.values()) {
            s.addAll(innerMap.values());
        }
        return s;
    }

    public Set<K1> firstKeySet() {
        return this.map.keySet();
    }

    public Set<K2> secondKeySet() {
        Set<K2> keys = Generics.newHashSet();
        for (K1 k1 : this.map.keySet()) {
            keys.addAll(this.get(k1).firstKeySet());
        }
        return keys;
    }

    public Set<K3> thirdKeySet() {
        Set<K3> keys = Generics.newHashSet();
        for (K1 k1 : this.map.keySet()) {
            TwoDimensionalMap<K2, K3, V> m = this.map.get(k1);
            for (K2 k2 : m.firstKeySet()) {
                keys.addAll(m.get(k2).keySet());
            }
        }
        return keys;
    }

    public String toString() {
        return this.map.toString();
    }
}

