/*
 * Decompiled with CFR 0.152.
 */
package matetools.is2.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import matetools.is2.data.IFV;
import matetools.is2.data.IntIntHash;
import matetools.is2.data.Long2IntInterface;

public final class FV
extends IFV {
    private FV subfv1;
    private FV subfv2;
    private boolean negateSecondSubFV = false;
    private int size;
    private int[] m_index;
    private static IntIntHash hm1;
    private static IntIntHash hm2;

    public FV() {
        this(10);
    }

    public FV(int initialCapacity) {
        this.m_index = new int[initialCapacity];
    }

    public FV(FV fv1, FV fv2) {
        this.subfv1 = fv1;
        this.subfv2 = fv2;
    }

    public FV(FV fv1, FV fv2, boolean negSecond) {
        this(0);
        this.subfv1 = fv1;
        this.subfv2 = fv2;
        this.negateSecondSubFV = negSecond;
    }

    public FV(DataInputStream dos, int capacity) throws IOException {
        this(capacity);
        this.size = this.m_index.length;
        int i = 0;
        while (i < this.size) {
            this.m_index[i] = dos.readInt();
            ++i;
        }
    }

    public FV(DataInputStream dos) throws IOException {
        this(dos.readInt());
        this.size = this.m_index.length;
        int i = 0;
        while (i < this.size) {
            this.m_index[i] = dos.readInt();
            ++i;
        }
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity > this.m_index.length) {
            int[] oldIndex = this.m_index;
            int newCapacity = this.m_index.length * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.m_index = new int[newCapacity];
            System.arraycopy(oldIndex, 0, this.m_index, 0, oldIndex.length);
        }
    }

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final void clear() {
        this.size = 0;
    }

    public final int createFeature(int i, double v) {
        this.ensureCapacity(this.size + 1);
        this.m_index[this.size] = i;
        ++this.size;
        return this.size - 1;
    }

    public final int createFeature(int i) {
        this.ensureCapacity(this.size + 1);
        this.m_index[this.size] = i;
        ++this.size;
        return this.size - 1;
    }

    public final int getIndex(int i) {
        return this.m_index[i];
    }

    public void setIndex(int p, int i) {
        this.m_index[p] = i;
    }

    public void trimToSize() {
        if (this.size < this.m_index.length) {
            int[] oldIndex = this.m_index;
            this.m_index = new int[this.size];
            System.arraycopy(oldIndex, 0, this.m_index, 0, this.size);
        }
    }

    @Override
    public final void add(int i) {
        if (i >= 0) {
            this.ensureCapacity(this.size + 1);
            this.m_index[this.size] = i;
            ++this.size;
        }
    }

    public final void add(int[] i) {
        int k = 0;
        while (k < i.length) {
            this.add(i[k]);
            ++k;
        }
    }

    public final void put(int i, double f) {
        if (i >= 0) {
            this.createFeature(i, f);
        }
    }

    public FV getDistVector(FV fl2) {
        return new FV(this, fl2, true);
    }

    public double getScore(double[] parameters, boolean negate) {
        double score = 0.0;
        if (this.subfv1 != null) {
            score += this.subfv1.getScore(parameters, negate);
            if (this.subfv2 != null) {
                score = negate ? (score += this.subfv2.getScore(parameters, !this.negateSecondSubFV)) : (score += this.subfv2.getScore(parameters, this.negateSecondSubFV));
            }
        }
        if (negate) {
            int i = 0;
            while (i < this.size) {
                score -= parameters[this.m_index[i]];
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                score += parameters[this.m_index[i]];
                ++i;
            }
        }
        return score;
    }

    public final float getScore(float[] parameters, boolean negate) {
        float score = 0.0f;
        if (this.subfv1 != null) {
            score += this.subfv1.getScore(parameters, negate);
            if (this.subfv2 != null) {
                score = negate ? (score += this.subfv2.getScore(parameters, !this.negateSecondSubFV)) : (score += this.subfv2.getScore(parameters, this.negateSecondSubFV));
            }
        }
        if (negate) {
            int i = 0;
            while (i < this.size) {
                score -= parameters[this.m_index[i]];
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                score += parameters[this.m_index[i]];
                ++i;
            }
        }
        return score;
    }

    public final int getScore(short[] parameters, boolean negate) {
        int score = 0;
        if (this.subfv1 != null) {
            score += this.subfv1.getScore(parameters, negate);
            if (this.subfv2 != null) {
                score = negate ? (score += this.subfv2.getScore(parameters, !this.negateSecondSubFV)) : (score += this.subfv2.getScore(parameters, this.negateSecondSubFV));
            }
        }
        if (negate) {
            int i = 0;
            while (i < this.size) {
                score -= parameters[this.m_index[i]];
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                score += parameters[this.m_index[i]];
                ++i;
            }
        }
        return score;
    }

    public void update(double[] parameters, double[] total, double alpha_k, double upd) {
        this.update(parameters, total, alpha_k, upd, false);
    }

    public final void update(double[] parameters, double[] total, double alpha_k, double upd, boolean negate) {
        if (this.subfv1 != null) {
            this.subfv1.update(parameters, total, alpha_k, upd, negate);
            if (this.subfv2 != null) {
                if (negate) {
                    this.subfv2.update(parameters, total, alpha_k, upd, !this.negateSecondSubFV);
                } else {
                    this.subfv2.update(parameters, total, alpha_k, upd, this.negateSecondSubFV);
                }
            }
        }
        if (negate) {
            int i = 0;
            while (i < this.size) {
                int n = this.m_index[i];
                parameters[n] = parameters[n] - alpha_k;
                int n2 = this.m_index[i];
                total[n2] = total[n2] - upd * alpha_k;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                int n = this.m_index[i];
                parameters[n] = parameters[n] + alpha_k;
                int n3 = this.m_index[i];
                total[n3] = total[n3] + upd * alpha_k;
                ++i;
            }
        }
    }

    public final void update(short[] parameters, short[] total, double alpha_k, double upd, boolean negate) {
        if (this.subfv1 != null) {
            this.subfv1.update(parameters, total, alpha_k, upd, negate);
            if (this.subfv2 != null) {
                if (negate) {
                    this.subfv2.update(parameters, total, alpha_k, upd, !this.negateSecondSubFV);
                } else {
                    this.subfv2.update(parameters, total, alpha_k, upd, this.negateSecondSubFV);
                }
            }
        }
        if (negate) {
            int i = 0;
            while (i < this.size) {
                int n = this.m_index[i];
                parameters[n] = (short)((double)parameters[n] - alpha_k);
                int n2 = this.m_index[i];
                total[n2] = (short)((double)total[n2] - upd * alpha_k);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                int n = this.m_index[i];
                parameters[n] = (short)((double)parameters[n] + alpha_k);
                int n3 = this.m_index[i];
                total[n3] = (short)((double)total[n3] + upd * alpha_k);
                ++i;
            }
        }
    }

    public final void update(float[] parameters, float[] total, double alpha_k, double upd, boolean negate) {
        if (this.subfv1 != null) {
            this.subfv1.update(parameters, total, alpha_k, upd, negate);
            if (this.subfv2 != null && negate) {
                this.subfv2.update(parameters, total, alpha_k, upd, !this.negateSecondSubFV);
            } else {
                this.subfv2.update(parameters, total, alpha_k, upd, this.negateSecondSubFV);
            }
        }
        if (negate) {
            int i = 0;
            while (i < this.size) {
                int n = this.getIndex(i);
                parameters[n] = (float)((double)parameters[n] - alpha_k);
                int n2 = this.getIndex(i);
                total[n2] = (float)((double)total[n2] - upd * alpha_k);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                int n = this.getIndex(i);
                parameters[n] = (float)((double)parameters[n] + alpha_k);
                int n3 = this.getIndex(i);
                total[n3] = (float)((double)total[n3] + upd * alpha_k);
                ++i;
            }
        }
    }

    public final void update(float[] parameters, float[] total, double alpha_k, double upd, boolean negate, float[] totalp, Long2IntInterface li) {
        if (this.subfv1 != null) {
            this.subfv1.update(parameters, total, alpha_k, upd, negate, totalp, li);
            if (this.subfv2 != null && negate) {
                this.subfv2.update(parameters, total, alpha_k, upd, !this.negateSecondSubFV, totalp, li);
            } else {
                this.subfv2.update(parameters, total, alpha_k, upd, this.negateSecondSubFV, totalp, li);
            }
        }
        if (negate) {
            int i = 0;
            while (i < this.size) {
                int n = this.getIndex(i);
                parameters[n] = (float)((double)parameters[n] - alpha_k);
                int n2 = this.getIndex(i);
                total[n2] = (float)((double)total[n2] - upd * alpha_k);
                int n3 = li.l2i(this.getIndex(i));
                totalp[n3] = (float)((double)totalp[n3] - upd * alpha_k);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                int n = this.getIndex(i);
                parameters[n] = (float)((double)parameters[n] + alpha_k);
                int n4 = this.getIndex(i);
                total[n4] = (float)((double)total[n4] + upd * alpha_k);
                int n5 = li.l2i(this.getIndex(i));
                totalp[n5] = (float)((double)totalp[n5] + upd * alpha_k);
                ++i;
            }
        }
    }

    public int dotProduct(FV fl2) {
        if (hm1 == null) {
            hm1 = new IntIntHash(this.size(), 0.4f);
        } else {
            hm1.clear();
        }
        this.addFeaturesToMap(hm1);
        if (hm2 == null) {
            hm2 = new IntIntHash(fl2.size, 0.4f);
        } else {
            hm2.clear();
        }
        fl2.addFeaturesToMap(hm2);
        int[] keys = hm1.keys();
        int result = 0;
        int i = 0;
        while (i < keys.length) {
            result += hm1.get(keys[i]) * hm2.get(keys[i]);
            ++i;
        }
        return result;
    }

    public double twoNorm(FV fl2) {
        if (hm1 == null) {
            hm1 = new IntIntHash(this.size(), 0.4f);
        } else {
            hm1.clear();
        }
        this.addFeaturesToMap(hm1);
        if (hm2 == null) {
            hm2 = new IntIntHash(fl2.size, 0.4f);
        } else {
            hm2.clear();
        }
        fl2.addFeaturesToMap(hm2);
        int[] keys = hm1.keys();
        int result = 0;
        int i = 0;
        while (i < keys.length) {
            result += hm1.get(keys[i]) * hm2.get(keys[i]);
            ++i;
        }
        return Math.sqrt(result);
    }

    public void addFeaturesToMap(IntIntHash map) {
        if (this.subfv1 != null) {
            this.subfv1.addFeaturesToMap(map);
            if (this.subfv2 != null) {
                this.subfv2.addFeaturesToMap(map, this.negateSecondSubFV);
            }
        }
        int i = 0;
        while (i < this.size) {
            if (!map.adjustValue(this.getIndex(i), 1)) {
                map.put(this.getIndex(i), 1);
            }
            ++i;
        }
    }

    private void addFeaturesToMap(IntIntHash map, boolean negate) {
        if (this.subfv1 != null) {
            this.subfv1.addFeaturesToMap(map, negate);
            if (this.subfv2 != null) {
                if (negate) {
                    this.subfv2.addFeaturesToMap(map, !this.negateSecondSubFV);
                } else {
                    this.subfv2.addFeaturesToMap(map, this.negateSecondSubFV);
                }
            }
        }
        if (negate) {
            int i = 0;
            while (i < this.size) {
                if (!map.adjustValue(this.getIndex(i), -1)) {
                    map.put(this.getIndex(i), -1);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                if (!map.adjustValue(this.getIndex(i), 1)) {
                    map.put(this.getIndex(i), 1);
                }
                ++i;
            }
        }
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    private final void toString(StringBuilder sb) {
        if (this.subfv1 != null) {
            this.subfv1.toString(sb);
            if (this.subfv2 != null) {
                this.subfv2.toString(sb);
            }
        }
        int i = 0;
        while (i < this.size) {
            sb.append(this.getIndex(i)).append(' ');
            ++i;
        }
    }

    public void writeKeys(DataOutputStream dos) throws IOException {
        dos.writeInt(this.size);
        int i = 0;
        while (i < this.size) {
            dos.writeInt(this.m_index[i]);
            ++i;
        }
    }

    public void readKeys(DataInputStream dos) throws IOException {
        int keys = dos.readInt();
        int i = 0;
        while (i < keys) {
            this.createFeature(dos.readInt(), 1.0);
            ++i;
        }
    }

    public static final FV cat(FV f1, FV f2) {
        if (f1 == null) {
            return f2;
        }
        if (f2 == null) {
            return f1;
        }
        return new FV(f1, f2);
    }

    public static final FV cat(FV f1, FV f2, FV f3) {
        return FV.cat(f1, FV.cat(f2, f3));
    }

    public static final FV cat(FV f1, FV f2, FV f3, FV f4) {
        return FV.cat(f1, FV.cat(f2, FV.cat(f3, f4)));
    }

    public static final FV read(DataInputStream dis) throws IOException {
        int cap = dis.readInt();
        if (cap == 0) {
            return null;
        }
        return new FV(dis, cap);
    }

    @Override
    public double getScore() {
        return 0.0;
    }

    @Override
    public IFV clone() {
        FV f = new FV(this.size);
        int i = 0;
        while (i < this.size) {
            f.m_index[i] = this.m_index[i];
            ++i;
        }
        f.size = this.size;
        return f;
    }

    public void update(float[] parameters, double cost, boolean negate) {
        if (this.subfv1 != null) {
            this.subfv1.update(parameters, cost, negate);
            if (this.subfv2 != null) {
                this.subfv2.update(parameters, cost, this.negateSecondSubFV);
            }
        }
        if (negate) {
            int i = 0;
            while (i < this.size) {
                int n = this.getIndex(i);
                parameters[n] = (float)((double)parameters[n] - cost);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                int n = this.getIndex(i);
                parameters[n] = (float)((double)parameters[n] + cost);
                ++i;
            }
        }
    }
}

