/*
 * Decompiled with CFR 0.152.
 */
package jigsaw.syntax;

import java.io.Serializable;
import java.util.Arrays;

public class Rule
implements Serializable {
    private static final long serialVersionUID = 4902245258139401162L;
    private int _id = -1;
    private int _lhs = -1;
    private int[] _rhs = null;
    private int _freq = 0;

    public Rule(int lhs, int[] rhs) {
        this._lhs = lhs;
        this._rhs = rhs;
    }

    public Rule(int lhs, int[] rhs, int freq) {
        this(lhs, rhs);
        this._freq = freq;
    }

    public int lhs() {
        return this._lhs;
    }

    public int[] rhs() {
        return this._rhs;
    }

    public int freq() {
        return this._freq;
    }

    public int incr() {
        return ++this._freq;
    }

    public int arity() {
        return this._rhs.length;
    }

    public int id() {
        return this._id;
    }

    public void id(int i) {
        this._id = i;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Rule)) {
            return false;
        }
        Rule that = (Rule)o;
        return this._lhs == that._lhs && Arrays.equals(this._rhs, that._rhs);
    }

    public int hashCode() {
        int prime = 97;
        int result = 1;
        result = 97 * result + this._lhs;
        int[] nArray = this._rhs;
        int n = this._rhs.length;
        int n2 = 0;
        while (n2 < n) {
            int c = nArray[n2];
            result = 97 * result + c;
            ++n2;
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._freq);
        sb.append(" ");
        sb.append(this._lhs);
        int[] nArray = this._rhs;
        int n = this._rhs.length;
        int n2 = 0;
        while (n2 < n) {
            int r = nArray[n2];
            sb.append(" ");
            sb.append(r);
            ++n2;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        int[] rhs = new int[]{3, 17, -23};
        Rule r = new Rule(253, rhs, 16);
        System.out.println(r.toString());
        int[] newrhs = r.rhs();
        newrhs[0] = 15;
        System.out.println(r.toString());
    }
}

