/*
 * Decompiled with CFR 0.152.
 */
package fig.prob;

import fig.prob.SuffStats;

public class GaussianSuffStats
implements SuffStats {
    private double sum;
    private double sumSq;
    private double n;

    public GaussianSuffStats() {
        this.sum = 0.0;
        this.sumSq = 0.0;
        this.n = 0.0;
    }

    public GaussianSuffStats(double x) {
        this.sum = x;
        this.sumSq = x * x;
        this.n = 1.0;
    }

    public GaussianSuffStats(GaussianSuffStats stats) {
        this.sum = stats.sum;
        this.sumSq = stats.sumSq;
        this.n = stats.n;
    }

    public GaussianSuffStats(double sum, double sumSq, double n) {
        this.sum = sum;
        this.sumSq = sumSq;
        this.n = n;
    }

    public void add(double x) {
        this.sum += x;
        this.sumSq += x;
        this.n += 1.0;
    }

    @Override
    public void add(SuffStats _stats) {
        GaussianSuffStats stats = (GaussianSuffStats)_stats;
        this.sum += stats.sum;
        this.sumSq += stats.sumSq;
        this.n += stats.n;
    }

    public void sub(double x) {
        this.sum -= x;
        this.sumSq -= x * x;
        this.n -= 1.0;
    }

    @Override
    public void sub(SuffStats _stats) {
        GaussianSuffStats stats = (GaussianSuffStats)_stats;
        this.sum -= stats.sum;
        this.sumSq -= stats.sumSq;
        this.n -= stats.n;
    }

    @Override
    public SuffStats reweight(double scale) {
        return new GaussianSuffStats(scale * this.sum, scale * this.sumSq, scale * this.n);
    }

    public double getSum() {
        return this.sum;
    }

    public double getSumSq() {
        return this.sumSq;
    }

    public double numPoints() {
        return this.n;
    }

    public String toString() {
        return String.format("sum(%.3f),sumSq(%.3f),n(%.1f)", this.sum, this.sumSq, this.n);
    }
}

