/*
 * Decompiled with CFR 0.152.
 */
package SyntaxUtils;

import LinguaView.syntax.CCGNode;
import SyntaxUtils.SentenceForCCGParsing;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class Sentence {
    protected List<String> words = new ArrayList<String>();
    protected List<String> poss = new ArrayList<String>();

    public int length() {
        return this.words.size();
    }

    public String word(int k) {
        if (k >= 0 && k < this.length()) {
            return this.words.get(k);
        }
        if (k < 0) {
            return "#BOS#";
        }
        return "#EOS#";
    }

    public String pos(int k) {
        if (k >= 0 && k < this.length()) {
            return this.poss.get(k);
        }
        if (k < 0) {
            return "#BOS#";
        }
        return "#EOS#";
    }

    protected Sentence() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.words.get(0)) + "/" + this.poss.get(0));
        int i = 1;
        while (i < this.words.size()) {
            sb.append(" " + this.words.get(i) + "/" + this.poss.get(i));
            ++i;
        }
        return sb.toString();
    }

    public String dumpWord() {
        StringBuffer sb = new StringBuffer(this.words.get(0));
        int i = 1;
        while (i < this.length()) {
            sb.append(" " + this.words.get(i));
            ++i;
        }
        return sb.toString();
    }

    public String dumpWordAndPos() {
        StringBuffer sb = new StringBuffer(String.valueOf(this.words.get(0)) + "/" + this.poss.get(0));
        int i = 1;
        while (i < this.length()) {
            sb.append(" " + this.words.get(i) + '/' + this.poss.get(i));
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.err.println("Usage: CCGFile wordFile PosFile");
            System.exit(1);
        }
        ArrayList<CCGNode> trees = CCGNode.readCCGFile(new File(args[0]), "UTF-8");
        PrintWriter[] ww = new PrintWriter[10];
        PrintWriter[] pw = new PrintWriter[10];
        int i = 0;
        while (i < 10) {
            ww[i] = new PrintWriter(String.valueOf(args[1]) + i);
            pw[i] = new PrintWriter(String.valueOf(args[2]) + i);
            ++i;
        }
        int partialSize = trees.size() / 10 + 1;
        int i2 = 0;
        while (i2 < trees.size()) {
            SentenceForCCGParsing sent = new SentenceForCCGParsing((CCGNode)trees.get(i2));
            ww[i2 / partialSize].println(sent.dumpWord());
            pw[i2 / partialSize].println(sent.dumpWordAndPos());
            ++i2;
        }
        i2 = 0;
        while (i2 < 10) {
            ww[i2].close();
            pw[i2].close();
            ++i2;
        }
    }
}

