###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################

#!/usr/bin/ruby

#####################################################################
# propArgs.rb
# Tim Miller
# 
# This script works on binarized trees in a top-down fashion to propagate
# argument structure, to emulate some features of lexicalization without
# requiring any changes to the parser.
# Rules of type X -> X NP will be changed to X -> X-argNP NP
# and the same with S.
#
######################################################################

require "scripts/umnlp.rb"

$error = false
$line = ""

class Tree
  def toDat ( depth, qParent )

    if @children.size==0
      $stderr.print "ERROR: EXPECT (PRETERM), POS, WORD NODES IN RCTREE!!! curr:"+@head + "\nLine=#{$line}\n"
      return
    end
    if @children.size==1 && @children[0].children.size==1 && @children[0].children[0].children.size!=0
      $stderr.print "ERROR: EXPECT (PRETERM), POS, WORD NODES IN RCTREE!!! curr:"+@head + " child:"+@children[0].head + " granch:"+@children[0].children[0].head + "\n"
      return
    end

    ## terminal case, left child post-transform
    if @children.size==1 && @children[0].children.size==1 && @children[0].children[0].children.size==0
      pos = @children[0].children[0].head.gsub(/([^\#]*)\#.*/,'\1')
      if depth<5
        print "Qe " + depth.to_s + " " + qParent + " : " + @children[0].head+"/"+@children[0].head + "\n"
        print "Qe " + (depth+1).to_s + " " + @children[0].head+"/"+@children[0].head + " : -/-\n"
        print "Pg " + @children[0].head + " : " + pos + "\n"
        print "Fr " + depth.to_s + " " + @children[0].head+"/"+@children[0].head + " " + qParent + " : 1\n"
        print "Qtp " + depth.to_s + " " + @children[0].head+"/"+@children[0].head + " " + qParent + " : " + @head + "\n"
      end
      ## if beyond max depth...
      if depth>=5
        $stderr.print "ERROR: TREE TOO BIG!!!\n"
      end
      #word = @children[0].children[0].head.gsub(/.*\#(.*)/,'\1')
      #print "Pw " + word + " : " + pos + "\n"
      #if word == ""
      #  $error = true
      #end
      return

    ## terminal case, right child post-transform
    elsif @children.size==1 && @children[0].children.size==0
      ## make sure head label equal to pos...
      pos = @children[0].head.gsub(/([^\#]*)\#.*/,'\1')

      if depth<5
        print "Qe " + depth.to_s + " " + qParent + " : " + @head+"/"+@head + "\n"
        print "Pg " + @head + " : " + pos + "\n"
        print "Fr " + depth.to_s + " " + @head+"/"+@head + " " + qParent + " : " + @head + "\n"
      elsif depth==5
        print "Ge5 " + " " + qParent + " : " + @head + "\n"
        print "Pg " + @head + " : " + pos + "\n"
      end

      #word = @children[0].head.gsub(/.*\#(.*)/,'\1')
      #print "Pw " + word + " : " + pos + "\n"
      #if word == ""
      #  $error = true
      #end
      return

    ## unary case
    elsif @children.size==1
      ## recurse to unary child...
      @children[0].toDat(depth,qParent)
      print "Fr " + depth.to_s + " " + @children[0].children[0].head + " " + qParent + " : 1\n"
      print "Qtp " + depth.to_s + " " + @children[0].children[0].head + " " + qParent + " : " + @head + "\n"
      return

    ## binary case remaining incomplete
    elsif @children.size==2 && @head=~/\//
      ## recurse to left child...
      @children[0].toDat(depth,qParent)
      ## recurse to right child...
      @children[1].toDat(depth+1,@children[0].head)
      print "Fr " + depth.to_s + " " + @children[0].head + " " + qParent + " : 0\n"
      print "Qtm " + depth.to_s + " " + @children[1].head + " " + @children[0].head + " " + qParent + " : " + @head + "\n"
      return

    ## binary case becoming complete
    elsif @children.size==2 && @head!~/\//
      ## recurse to left child...
      @children[0].toDat(depth,qParent)
      ## recurse to right child...
      @children[1].toDat(depth+1,@children[0].head)
      print "Fr " + depth.to_s + " " + @children[0].head + " " + qParent + " : " + @head + "\n"
      return
    end

    $stderr.print "ERROR: N-ARY BRANCH IN RCTREE!!!\n"
    return

  end
end

while($line = gets)
  t = Tree.new($line)
#  begin
  ##(composL,continL) = 
  t.toDat(1,"ROOT/REST")
  if $error
    $stderr.puts "\nWARNING: This tree generated a word-less Pw: #{t}\n"
    $error = false
  end
  ## top node was final...
  #print "Fr 1 S : 1\n"
  #print "Fr 1 " + t.children[0].head + " : " + t.head + "\n"

#   for d in 1..4
#     print "Qe " + d.to_s + " -/- : -/-\n"
#     print "Fr " + d.to_s + " -/- : -\n"
#   end

#  rescue Exception
#    $stderr.puts "Skipping sentence: #{$line}"
#  end
  #print "F  1 S END/END|END : 1\n"
  #for d in 1..4
  #  print "F  " + d.to_s + " END END/END|END : 1\n"
  #end
end
