/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.algorithm.twoplanar3T;

import java.util.Set;
import java.util.Stack;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.core.syntaxgraph.edge.Edge;
import org.maltparser.core.syntaxgraph.node.DependencyNode;
import org.maltparser.core.syntaxgraph.node.TokenNode;
import org.maltparser.parser.ParserConfiguration;
import org.maltparser.parser.TransitionSystem;
import org.maltparser.parser.algorithm.twoplanar3T.TwoPlanar3TConfig;
import org.maltparser.parser.history.GuideUserHistory;
import org.maltparser.parser.history.History;
import org.maltparser.parser.history.action.ComplexDecisionAction;
import org.maltparser.parser.history.action.GuideUserAction;
import org.maltparser.parser.transition.TransitionTable;

public class TwoPlanar3T
extends TransitionSystem {
    protected static final int SHIFT = 1;
    protected static final int SWITCH = 2;
    protected static final int ARC = 3;
    protected static final int REDUCE = 4;
    protected static final int REDUCEBOTH = 5;

    public void apply(GuideUserAction currentAction, ParserConfiguration config) throws MaltChainedException {
        TwoPlanar3TConfig planarConfig = (TwoPlanar3TConfig)config;
        Stack<DependencyNode> activeStack = planarConfig.getActiveStack();
        Stack<DependencyNode> inactiveStack = planarConfig.getInactiveStack();
        Stack<DependencyNode> input = planarConfig.getInput();
        currentAction.getAction(this.actionContainers);
        Edge e = null;
        switch (this.transActionContainer.getActionCode()) {
            case 3: {
                e = planarConfig.getDependencyStructure().addDependencyEdge(activeStack.peek().getIndex(), input.peek().getIndex());
                this.addEdgeLabels(e);
                break;
            }
            case 2: {
                planarConfig.switchStacks();
                if (!planarConfig.reduceAfterSwitch()) break;
                planarConfig.getActiveStack().pop();
                break;
            }
            case 4: {
                activeStack.pop();
                break;
            }
            case 5: {
                activeStack.pop();
                inactiveStack.pop();
                break;
            }
            default: {
                DependencyNode n = input.pop();
                activeStack.push(n);
                inactiveStack.push(n);
            }
        }
    }

    public GuideUserAction getDeterministicAction(GuideUserHistory history, ParserConfiguration config) throws MaltChainedException {
        TwoPlanar3TConfig theConfig = (TwoPlanar3TConfig)config;
        if (theConfig.getRootHandling() != 1 && theConfig.getActiveStack().peek().isRoot()) {
            return this.updateActionContainers(history, 1, null);
        }
        return null;
    }

    protected void addAvailableTransitionToTable(TransitionTable ttable) throws MaltChainedException {
        ttable.addTransition(1, "SH", false, null);
        ttable.addTransition(4, "RE", false, null);
        ttable.addTransition(3, "AR", true, null);
        ttable.addTransition(2, "SW", false, null);
        ttable.addTransition(5, "RB", false, null);
    }

    protected void initWithDefaultTransitions(GuideUserHistory history) throws MaltChainedException {
        ComplexDecisionAction currentAction = new ComplexDecisionAction((History)history);
        this.transActionContainer.setAction(1);
        this.transActionContainer.setAction(4);
        this.transActionContainer.setAction(2);
        this.transActionContainer.setAction(5);
        for (int i = 0; i < this.arcLabelActionContainers.length; ++i) {
            this.arcLabelActionContainers[i].setAction(-1);
        }
        currentAction.addAction(this.actionContainers);
    }

    public String getName() {
        return "two-planar 3t arc-eager";
    }

    public boolean permissible(GuideUserAction currentAction, ParserConfiguration config) throws MaltChainedException {
        currentAction.getAction(this.actionContainers);
        int trans = this.transActionContainer.getActionCode();
        TwoPlanar3TConfig planarConfig = (TwoPlanar3TConfig)config;
        DependencyNode activeStackPeek = planarConfig.getActiveStack().peek();
        DependencyNode inactiveStackPeek = planarConfig.getInactiveStack().peek();
        DependencyNode inputPeek = planarConfig.getInput().peek();
        DependencyStructure dg = planarConfig.getDependencyGraph();
        boolean singleHeadConstraint = planarConfig.requiresSingleHead();
        boolean noCoveredRootsConstraint = planarConfig.requiresNoCoveredRoots();
        boolean acyclicityConstraint = planarConfig.requiresAcyclicity();
        if (trans == 3 && !this.isActionContainersLabeled()) {
            return false;
        }
        if (trans == 3) {
            if (this.checkIfNodesAreRelated(dg, inputPeek.getIndex(), activeStackPeek.getIndex())) {
                return false;
            }
            if (acyclicityConstraint && activeStackPeek.findComponent().getIndex() == inputPeek.findComponent().getIndex()) {
                return false;
            }
        }
        if (trans == 4) {
            if (activeStackPeek.isRoot()) {
                return false;
            }
            if (!activeStackPeek.hasHead() && noCoveredRootsConstraint) {
                return false;
            }
        }
        if (trans == 1) {
            // empty if block
        }
        if (trans == 5) {
            if (activeStackPeek.isRoot() || inactiveStackPeek.isRoot()) {
                return false;
            }
            if ((!activeStackPeek.hasHead() || inactiveStackPeek.hasHead()) && noCoveredRootsConstraint) {
                return false;
            }
            return false;
        }
        if (trans == 2) {
            if (planarConfig.reduceAfterSwitch()) {
                if (inactiveStackPeek.isRoot()) {
                    return false;
                }
                if (!inactiveStackPeek.hasHead() && noCoveredRootsConstraint) {
                    return false;
                }
            } else if (planarConfig.getLastAction() == 2) {
                return false;
            }
        }
        return true;
    }

    public GuideUserAction defaultAction(GuideUserHistory history, ParserConfiguration configuration) throws MaltChainedException {
        return this.updateActionContainers(history, 1, null);
    }

    private boolean checkIfNodesAreRelated(DependencyStructure dg, int index1, int index2) throws MaltChainedException {
        TokenNode tk = dg.getTokenNode(index1);
        Set<DependencyNode> heads = null;
        if (tk != null) {
            heads = tk.getHeads();
            for (DependencyNode head : heads) {
                if (head.getIndex() != index2) continue;
                return true;
            }
        }
        if ((tk = dg.getTokenNode(index2)) != null) {
            heads = tk.getHeads();
            for (DependencyNode head : heads) {
                if (head.getIndex() != index1) continue;
                return true;
            }
        }
        return false;
    }
}

