/*
 * Decompiled with CFR 0.152.
 */
package symbols;

import java.util.Hashtable;
import java.util.Vector;
import symbols.Symbol;

public class SymbolObject
extends Symbol {
    protected static Hashtable<Object, Integer> IDtableSymbol = new Hashtable();
    protected static Vector<Object> IDtableReverseSymbol = new Vector();
    protected static Vector<SymbolObject> SymbolVector = new Vector();
    protected static int SymbolCounter;

    public static int getSymbolCounter() {
        return SymbolCounter;
    }

    public SymbolObject(Object symbol) {
        Integer storedId = IDtableSymbol.get(symbol);
        if (storedId == null) {
            storedId = SymbolCounter++;
            IDtableSymbol.put(symbol, storedId);
            IDtableReverseSymbol.add(symbol);
            SymbolVector.add(this);
        }
        this.id = storedId;
    }

    @Override
    public Object getOriginalObject() {
        return IDtableReverseSymbol.get(this.id);
    }

    public void relabel(Object newSymbol) {
        IDtableSymbol.remove(this.getOriginalObject());
        Integer storedId = IDtableSymbol.get(newSymbol);
        if (storedId == null) {
            IDtableSymbol.put(newSymbol, this.id);
            IDtableReverseSymbol.set(this.id, newSymbol);
            SymbolVector.set(this.id, this);
        } else {
            this.id = storedId;
        }
    }

    @Override
    public String toString() {
        return this.getOriginalObject().toString();
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof SymbolObject) {
            SymbolObject anotherSymbol = (SymbolObject)anObject;
            return this.id == anotherSymbol.id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(SymbolObject anotherSymbol) {
        return this.id == anotherSymbol.id;
    }
}

