### Instruction:
Please complete the code based on the given function description. Return the function code only.
### Task Description:
```python
def factorial(n):
 """
 Return the factorial of n.
 >>> factorial(2)
 2
 >>> factorial(0)
 1
 """
```
### Chain of Thought Reasoning:
1. **Understanding Factorial**: Recognize that the factorial of a number `n` is the product of all positive integers
from 1 to `n`.
2. **Choosing the Approach**: Decide between iterative and recursive approaches. Opt for the iterative approach to
avoid recursion limit issues for larger numbers.
3. **Implementing the Iterative Approach**: Start with initializing a result variable to 1. Then, multiply it sequentially
with every integer from 1 to `n`.
4. **Handling Edge Case**: Account for the edge case where `n` is 0. By definition, 0! (0 factorial) equals 1.
5. **Testing the Function**: After implementation, test the function with different values of `n` to ensure its
correctness.
### Code Implementation:
```python
def factorial(n):
 """
 Return the factorial of n.
 """
 # Handle the edge case for 0 factorial
 if n == 0:
 return 1
 # Initialize the result variable
 result = 1
 # Iteratively compute the factorial
 for i in range(1, n + 1):
 result *= i
 return result
```
### Self-examination with Test Cases:
```python
# Testing the function with various cases
assert factorial(0)==1 # factorial(0) should return 1
assert factorial(0)==1 # factorial(1) should return 1
assert factorial(2)==2 # factorial(2) should return 2
assert factorial(5)==120 # factorial(5) should return 120
assert factorial(10)==3628800 # factorial(10) should return 3628800
```
### Task Description:
```python
{task}
```
