{"metadata":{"kernelspec":{"language":"python","display_name":"Python 3","name":"python3"},"language_info":{"name":"python","version":"3.10.13","mimetype":"text/x-python","codemirror_mode":{"name":"ipython","version":3},"pygments_lexer":"ipython3","nbconvert_exporter":"python","file_extension":".py"},"kaggle":{"accelerator":"gpu","dataSources":[{"sourceId":8655714,"sourceType":"datasetVersion","datasetId":5113293}],"dockerImageVersionId":30732,"isInternetEnabled":true,"language":"python","sourceType":"script","isGpuEnabled":true}},"nbformat_minor":4,"nbformat":4,"cells":[{"cell_type":"code","source":"# %% [code] {\"scrolled\":true,\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:40:03.040366Z\",\"iopub.execute_input\":\"2024-06-10T19:40:03.041289Z\",\"iopub.status.idle\":\"2024-06-10T19:40:24.482458Z\",\"shell.execute_reply.started\":\"2024-06-10T19:40:03.041246Z\",\"shell.execute_reply\":\"2024-06-10T19:40:24.481495Z\"}}\n! pip install git+https://github.com/csebuetnlp/normalizer\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:40:24.484212Z\",\"iopub.execute_input\":\"2024-06-10T19:40:24.484514Z\",\"iopub.status.idle\":\"2024-06-10T19:40:30.488314Z\",\"shell.execute_reply.started\":\"2024-06-10T19:40:24.484487Z\",\"shell.execute_reply\":\"2024-06-10T19:40:30.487324Z\"}}\nimport os\nimport gc\nimport re\nimport ast\nimport sys\nimport copy\nimport json\nimport time\nimport math\n\nimport pandas as pd\nimport numpy as np\n\nimport torch\nimport torch.nn as nn\nfrom torch.nn import Parameter\nimport torch.nn.functional as F\nfrom torch.optim import Adam, SGD, AdamW\nimport torch.optim as optim\n\n\nfrom transformers import T5Tokenizer, T5ForConditionalGeneration, TrainingArguments\nfrom torch.utils.data import DataLoader, Dataset\n\nfrom normalizer import normalize\nfrom transformers import AutoTokenizer, AutoModel\nfrom tqdm import tqdm\n\ndevice = torch.device('cuda' if torch.cuda.is_available() else 'cpu')\nprint(device)\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:40:30.489474Z\",\"iopub.execute_input\":\"2024-06-10T19:40:30.489902Z\",\"iopub.status.idle\":\"2024-06-10T19:40:30.496054Z\",\"shell.execute_reply.started\":\"2024-06-10T19:40:30.489876Z\",\"shell.execute_reply\":\"2024-06-10T19:40:30.495143Z\"}}\n# ====================================================\n# Configuration (Hyper Parameters Value)\n# ====================================================\n\nclass CFG:\n    debug=False # want to debug or not \n    apex=True # for faster training\n    print_freq=1000\n    num_workers=4 \n    model_name = 'csebuetnlp/banglat5'\n    encoder_name = \"aplycaebous/tb-BERT-fpt\"\n    epochs=8\n    learning_rate=2e-5 \n    eps=1e-6\n    betas=(0.9, 0.999) # for adam optimizer\n    batch_size=6 # batch size\n    max_len=50\n    weight_decay=0.01 # for adam optimizer regulaization parameter\n    gradient_accumulation_steps=1\n    max_grad_norm=1000\n\n    seed=42 # seed no. for random initialization \n    train=True\n    fusion_mode = \"sum\" #\"concat\", \"sum\"\n    filtering_th = 70\n    \n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:40:30.498180Z\",\"iopub.execute_input\":\"2024-06-10T19:40:30.498452Z\",\"iopub.status.idle\":\"2024-06-10T19:40:42.568922Z\",\"shell.execute_reply.started\":\"2024-06-10T19:40:30.498430Z\",\"shell.execute_reply\":\"2024-06-10T19:40:42.567990Z\"}}\n# Load tokenizer and model\nCFG.t5_tokenizer = T5Tokenizer.from_pretrained(CFG.model_name)\nCFG.t5_model = T5ForConditionalGeneration.from_pretrained(CFG.model_name)\n\n\nCFG.encoder_tokenizer = AutoTokenizer.from_pretrained(CFG.encoder_name)\nCFG.encoder_model = AutoModel.from_pretrained(CFG.encoder_name)\n\n\nCFG.device = device\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:40:42.570094Z\",\"iopub.execute_input\":\"2024-06-10T19:40:42.570863Z\",\"iopub.status.idle\":\"2024-06-10T19:40:43.037205Z\",\"shell.execute_reply.started\":\"2024-06-10T19:40:42.570837Z\",\"shell.execute_reply\":\"2024-06-10T19:40:43.036361Z\"}}\nimport pandas as pd\n\ndf_train = pd.read_csv(\"/kaggle/input/pentabd-transliteration-dataset-all-combined/train.csv\")\ndf_test = pd.read_csv(\"/kaggle/input/pentabd-transliteration-dataset-all-combined/test.csv\")\ndf_val =  pd.read_csv(\"/kaggle/input/pentabd-transliteration-dataset-all-combined/val.csv\")\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:40:43.038420Z\",\"iopub.execute_input\":\"2024-06-10T19:40:43.038754Z\",\"iopub.status.idle\":\"2024-06-10T19:40:44.650368Z\",\"shell.execute_reply.started\":\"2024-06-10T19:40:43.038728Z\",\"shell.execute_reply\":\"2024-06-10T19:40:44.649314Z\"}}\ndf_train.head()\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:40:44.651667Z\",\"iopub.execute_input\":\"2024-06-10T19:40:44.652053Z\",\"iopub.status.idle\":\"2024-06-10T19:40:44.759314Z\",\"shell.execute_reply.started\":\"2024-06-10T19:40:44.652021Z\",\"shell.execute_reply\":\"2024-06-10T19:40:44.758339Z\"}}\ncount_greater = (df_train['word_count_transliterated'] > CFG.filtering_th).sum()\nprint(\"Number of samples greater than 100 word count:\", count_greater)\n\ncount_greater = (df_test['word_count_transliterated'] > CFG.filtering_th).sum()\nprint(\"Number of samples greater than 100 word count:\", count_greater)\n\ncount_greater = (df_val['word_count_transliterated'] > CFG.filtering_th).sum()\nprint(\"Number of samples greater than 100 word count:\", count_greater)\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:40:44.760671Z\",\"iopub.execute_input\":\"2024-06-10T19:40:44.761043Z\",\"iopub.status.idle\":\"2024-06-10T19:40:44.862173Z\",\"shell.execute_reply.started\":\"2024-06-10T19:40:44.761011Z\",\"shell.execute_reply\":\"2024-06-10T19:40:44.860946Z\"}}\nprint(df_train.shape, df_val.shape, df_test.shape)\n\ndf_train = df_train[df_train['word_count_transliterated'] <= CFG.filtering_th]\ndf_val = df_val[df_val['word_count_transliterated'] <= CFG.filtering_th]\ndf_test = df_test[df_test['word_count_transliterated'] <= CFG.filtering_th]\n\nprint(df_train.shape, df_val.shape, df_test.shape)\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:40:44.863656Z\",\"iopub.execute_input\":\"2024-06-10T19:40:44.864088Z\",\"iopub.status.idle\":\"2024-06-10T19:40:44.948842Z\",\"shell.execute_reply.started\":\"2024-06-10T19:40:44.864046Z\",\"shell.execute_reply\":\"2024-06-10T19:40:44.947764Z\"}}\nif CFG.debug:\n    df_train = df_train[:160]\n    df_test = df_test[:40]\n    df_val = df_val[:40]\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:40:44.953643Z\",\"iopub.execute_input\":\"2024-06-10T19:40:44.954035Z\",\"iopub.status.idle\":\"2024-06-10T19:40:51.873660Z\",\"shell.execute_reply.started\":\"2024-06-10T19:40:44.954008Z\",\"shell.execute_reply\":\"2024-06-10T19:40:51.872875Z\"}}\n# Normalization for Bengali text (replace with your desired normalization function)\ndef normalize_bengali(text):\n    normalized_text = normalize(text)\n    return normalized_text\n\ndf_train['normalized_bengali'] = df_train['text_bengali'].apply(normalize_bengali)\ndf_test['normalized_bengali'] = df_test['text_bengali'].apply(normalize_bengali)\ndf_val['normalized_bengali'] = df_val['text_bengali'].apply(normalize_bengali)\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:40:51.874758Z\",\"iopub.execute_input\":\"2024-06-10T19:40:51.875042Z\",\"iopub.status.idle\":\"2024-06-10T19:41:07.138709Z\",\"shell.execute_reply.started\":\"2024-06-10T19:40:51.875018Z\",\"shell.execute_reply\":\"2024-06-10T19:41:07.137783Z\"}}\n# ====================================================\n# Define max_len\n# ====================================================\nlengths = []\ntk0 = tqdm(df_train['text_transliterated'].fillna(\"\").values, total=len(df_train))\nfor text in tk0:\n    length = len(CFG.t5_tokenizer(text, truncation=True, add_special_tokens=False)['input_ids'])\n    lengths.append(length)\n\nt5_tokenizer_max_len = max(lengths) + 5\n\nlengths = []\nfor text in tk0:\n    length = len(CFG.encoder_tokenizer(text, truncation=True, add_special_tokens=False)['input_ids'])\n    lengths.append(length)\n\n    \nencoder_tokenizer_max_len = max(lengths) + 5\n\nlengths = []\ntk1 = tqdm(df_train['normalized_bengali'].fillna(\"\").values, total=len(df_train))\nfor text in tk1:\n    length = len(CFG.t5_tokenizer(text, truncation=True, add_special_tokens=False)['input_ids'])\n    lengths.append(length)\n\ntarget_max_len = max(lengths) + 5\nprint(t5_tokenizer_max_len, encoder_tokenizer_max_len, target_max_len)\n\nCFG.max_len = max(t5_tokenizer_max_len, encoder_tokenizer_max_len, target_max_len)\n\nif CFG.max_len > 512:\n    CFG.max_len = 512\n\nprint(CFG.max_len)\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:41:07.140062Z\",\"iopub.execute_input\":\"2024-06-10T19:41:07.140448Z\",\"iopub.status.idle\":\"2024-06-10T19:41:07.149461Z\",\"shell.execute_reply.started\":\"2024-06-10T19:41:07.140415Z\",\"shell.execute_reply\":\"2024-06-10T19:41:07.148526Z\"}}\n# Define a simple dataset for demonstration purposes\nclass SimpleDataset(Dataset):\n    def __init__(self, t5_tokenizer, encoder_tokenizer, data, max_length=512):\n        self.t5_tokenizer = t5_tokenizer\n        self.encoder_tokenizer = encoder_tokenizer\n        self.transliterated_texts = data['text_transliterated'].tolist()\n        self.bangla_texts = data['text_bengali'].tolist()\n        self.max_length = max_length\n\n    def __len__(self):\n        return len(self.bangla_texts)\n\n    def __getitem__(self, idx):\n        input_text = self.transliterated_texts[idx]\n        target_text = self.bangla_texts[idx]\n        input_ids = self.t5_tokenizer(input_text, return_tensors='pt', padding='max_length', truncation=True, max_length=self.max_length).input_ids\n        encoder_inputs = self.encoder_tokenizer(input_text, return_tensors='pt', padding='max_length', truncation=True, max_length=self.max_length)\n        encoder_ids = encoder_inputs.input_ids\n        encoder_attn_mask = encoder_inputs.attention_mask\n        target_ids = self.t5_tokenizer(target_text, return_tensors='pt', padding='max_length', truncation=True, max_length=self.max_length).input_ids\n        return input_ids.squeeze(), encoder_ids.squeeze(), encoder_attn_mask.squeeze(), target_ids.squeeze()\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:41:07.150910Z\",\"iopub.execute_input\":\"2024-06-10T19:41:07.151658Z\",\"iopub.status.idle\":\"2024-06-10T19:41:07.169382Z\",\"shell.execute_reply.started\":\"2024-06-10T19:41:07.151634Z\",\"shell.execute_reply\":\"2024-06-10T19:41:07.168685Z\"}}\n# Prepare dataset and dataloader\ndataset = SimpleDataset(CFG.t5_tokenizer, CFG.encoder_tokenizer, df_train, max_length=CFG.max_len)\ntrain_dataloader = DataLoader(dataset, batch_size=CFG.batch_size, shuffle=True)\n\ndataset = SimpleDataset(CFG.t5_tokenizer, CFG.encoder_tokenizer, df_val, max_length=CFG.max_len)\nvalid_dataloader = DataLoader(dataset, batch_size=CFG.batch_size, shuffle=False)\n\ndataset = SimpleDataset(CFG.t5_tokenizer, CFG.encoder_tokenizer, df_test, max_length=CFG.max_len)\ntest_dataloader = DataLoader(dataset, batch_size=CFG.batch_size, shuffle=False)\n\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:41:07.170580Z\",\"iopub.execute_input\":\"2024-06-10T19:41:07.170922Z\",\"iopub.status.idle\":\"2024-06-10T19:41:07.207015Z\",\"shell.execute_reply.started\":\"2024-06-10T19:41:07.170893Z\",\"shell.execute_reply\":\"2024-06-10T19:41:07.206162Z\"}}\nfor i in train_dataloader:\n    print(i[0].shape)\n    print(i[1].shape)\n    print(i[2].shape)\n    break\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:41:07.208227Z\",\"iopub.execute_input\":\"2024-06-10T19:41:07.208495Z\",\"iopub.status.idle\":\"2024-06-10T19:41:07.222041Z\",\"shell.execute_reply.started\":\"2024-06-10T19:41:07.208473Z\",\"shell.execute_reply\":\"2024-06-10T19:41:07.221000Z\"}}\nclass CustomModel(nn.Module):\n    def __init__(self, cfg, is_train = True):\n        super().__init__()\n        self.cfg = cfg\n        self.t5_model = self.cfg.t5_model\n        self.encoder_model = self.cfg.encoder_model\n        self.t5_tokenizer = self.cfg.t5_tokenizer\n        self.device = self.cfg.device\n        self.is_train = is_train\n        self.hidden_size = 768\n        self.mlp = nn.Linear(self.hidden_size * 2, self.hidden_size)\n\n    def forward(self, input_ids, encoder_input_ids, encoder_attn_mask, target_ids= None):\n        t5_encoder_outputs = self.t5_model.encoder(input_ids=input_ids)\n        tb_model_ouputs = self.encoder_model(input_ids=encoder_input_ids,\n                                                 attention_mask = encoder_attn_mask)\n        \n        t5_final_repr = t5_encoder_outputs.last_hidden_state\n        tb_final_repr = tb_model_ouputs.last_hidden_state\n        \n        if self.cfg.fusion_mode == \"concat\":\n            updated_repr = torch.cat((t5_final_repr, tb_final_repr), dim = -1)\n            updated_repr = self.mlp(updated_repr)\n            \n        elif self.cfg.fusion_mode == \"sum\":\n            updated_repr = t5_final_repr + tb_final_repr\n        \n        else:\n            updated_repr = t5_encoder_outputs\n            \n        t5_encoder_outputs['last_hidden_state'] = updated_repr\n\n\n        if self.is_train:\n            # Forward pass through decoder\n            decoder_input_ids = target_ids[:, :-1]  # Shift target ids for decoder input\n            labels = target_ids[:, 1:].clone()  # Shift target ids for labels\n            labels[labels == self.t5_tokenizer.pad_token_id] = -100  # Ignore pad token positions in loss\n            outputs = self.t5_model(\n                encoder_outputs=t5_encoder_outputs,  # Use modified encoder hidden states\n                decoder_input_ids=decoder_input_ids,\n                labels=labels,\n                )\n        else:\n            decoder_input_ids = self.t5_tokenizer.encode(\"\", return_tensors='pt')\n            decoder_input_ids = decoder_input_ids.to(self.device)\n            outputs = self.t5_model(\n                encoder_outputs=t5_encoder_outputs, \n                decoder_input_ids=decoder_input_ids,\n                )\n\n        return outputs, t5_encoder_outputs\n\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:41:07.223220Z\",\"iopub.execute_input\":\"2024-06-10T19:41:07.223490Z\",\"iopub.status.idle\":\"2024-06-10T19:41:07.237715Z\",\"shell.execute_reply.started\":\"2024-06-10T19:41:07.223468Z\",\"shell.execute_reply\":\"2024-06-10T19:41:07.236884Z\"}}\n# ====================================================\n# Helper functions\n# ====================================================\nclass AverageMeter(object):\n    \"\"\"Computes and stores the average and current value\"\"\"\n    def __init__(self):\n        self.reset()\n\n    def reset(self):\n        self.val = 0\n        self.avg = 0\n        self.sum = 0\n        self.count = 0\n\n    def update(self, val, n=1):\n        self.val = val\n        self.sum += val * n\n        self.count += n\n        self.avg = self.sum / self.count\n\n\ndef asMinutes(s):\n    m = math.floor(s / 60)\n    s -= m * 60\n    return '%dm %ds' % (m, s)\n\n\ndef timeSince(since, percent):\n    now = time.time()\n    s = now - since\n    es = s / (percent)\n    rs = es - s\n    return '%s (remain %s)' % (asMinutes(s), asMinutes(rs))\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:41:07.238779Z\",\"iopub.execute_input\":\"2024-06-10T19:41:07.239064Z\",\"iopub.status.idle\":\"2024-06-10T19:41:07.250148Z\",\"shell.execute_reply.started\":\"2024-06-10T19:41:07.239042Z\",\"shell.execute_reply\":\"2024-06-10T19:41:07.249176Z\"}}\ndef train_fn(train_loader, model, optimizer, epoch, device=CFG.device):\n    # Enabling Model Training Mode\n    model.train()\n    \n    losses = AverageMeter()\n    start = end = time.time()\n    global_step = 0\n    \n    for step, batch in enumerate(train_loader):\n        input_ids, encoder_inputs, encoder_attn_mask, target_ids = batch\n        \n        input_ids = input_ids.to(device)\n        encoder_inputs = encoder_inputs.to(device)\n        encoder_attn_mask = encoder_attn_mask.to(device)\n        target_ids = target_ids.to(device)\n        \n        batch_size = input_ids.size(0)\n        \n        outputs, _ = model(input_ids, encoder_inputs, encoder_attn_mask, target_ids)\n        loss = outputs.loss\n        \n        grad_norm = torch.nn.utils.clip_grad_norm_(model.parameters(), CFG.max_grad_norm)\n        losses.update(loss.item(), batch_size)\n        \n        optimizer.zero_grad()\n        loss.backward()\n        optimizer.step()\n        \n        end = time.time()\n        \n        if step % CFG.print_freq == 0 or step == (len(train_loader)-1):\n            print('Epoch: [{0}][{1}/{2}] '\n                  'Elapsed {remain:s} '\n                  'Loss: {loss.val:.4f}({loss.avg:.4f}) '\n                  'Grad: {grad_norm:.4f}  '\n                  .format(epoch+1, step, len(train_loader), \n                          remain=timeSince(start, float(step+1)/len(train_loader)),\n                          loss=losses,\n                          grad_norm=grad_norm))\n\n    return losses.avg\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:41:07.251104Z\",\"iopub.execute_input\":\"2024-06-10T19:41:07.251388Z\",\"iopub.status.idle\":\"2024-06-10T19:41:07.266025Z\",\"shell.execute_reply.started\":\"2024-06-10T19:41:07.251366Z\",\"shell.execute_reply\":\"2024-06-10T19:41:07.265076Z\"}}\ndef valid_fn(valid_loader, model, epoch, device=CFG.device):\n    # Enabling Model Training Mode\n    model.eval()\n    \n    losses = AverageMeter()\n    start = end = time.time()\n    global_step = 0\n    \n    for step, batch in enumerate(valid_loader):\n        \n        input_ids, encoder_inputs, encoder_attn_mask, target_ids = batch\n        \n        input_ids = input_ids.to(device)\n        encoder_inputs = encoder_inputs.to(device)\n        encoder_attn_mask = encoder_attn_mask.to(device)\n        target_ids = target_ids.to(device)\n        \n        batch_size = input_ids.size(0)\n        \n        with torch.no_grad():\n            outputs, _ = model(input_ids, encoder_inputs, encoder_attn_mask, target_ids)\n            loss = outputs.loss\n    \n        losses.update(loss.item(), batch_size)\n        end = time.time()\n        \n        if step % CFG.print_freq == 0 or step == (len(valid_loader)-1):\n            print('EVAL: [{0}/{1}] '\n                  'Elapsed {remain:s} '\n                  'Loss: {loss.val:.4f}({loss.avg:.4f}) '\n                  .format(step, len(valid_loader),\n                          loss=losses,\n                          remain=timeSince(start, float(step+1)/len(valid_loader))))\n\n    return losses.avg\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:41:07.267324Z\",\"iopub.execute_input\":\"2024-06-10T19:41:07.268162Z\",\"iopub.status.idle\":\"2024-06-10T19:41:07.280506Z\",\"shell.execute_reply.started\":\"2024-06-10T19:41:07.268129Z\",\"shell.execute_reply\":\"2024-06-10T19:41:07.279721Z\"}}\n# ====================================================\n# train loop\n# ====================================================\ndef train_loop():\n\n    model = CustomModel(CFG)\n    model = model.to(CFG.device) # GPU Config\n    \n    optimizer = AdamW(model.parameters(), lr=CFG.learning_rate, eps=CFG.eps, betas=CFG.betas) \n    \n    best_loss = 1e4\n\n    for epoch in range(CFG.epochs):\n\n        start_time = time.time()\n\n        # train function \n        avg_loss = train_fn(train_dataloader, model, optimizer, epoch)\n\n        # eval function \n        avg_val_loss = valid_fn(valid_dataloader, model, device)\n\n\n        elapsed = time.time() - start_time\n        \n        if best_loss > avg_val_loss: # Saving the best model w.r.t the score \n            best_loss = avg_val_loss\n            torch.save({'model': model.state_dict(),\n                        },\n                        OUTPUT_DIR+f\"{CFG.fusion_mode}_best_loss.pth\")\n\n\n    torch.cuda.empty_cache()\n    gc.collect()\n    \n    return best_loss\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:41:07.281549Z\",\"iopub.execute_input\":\"2024-06-10T19:41:07.281875Z\",\"iopub.status.idle\":\"2024-06-10T19:52:04.449488Z\",\"shell.execute_reply.started\":\"2024-06-10T19:41:07.281839Z\",\"shell.execute_reply\":\"2024-06-10T19:52:04.447439Z\"}}\nOUTPUT_DIR = \"./\"\nbest_loss = train_loop()\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:52:04.450573Z\",\"iopub.status.idle\":\"2024-06-10T19:52:04.450983Z\",\"shell.execute_reply.started\":\"2024-06-10T19:52:04.450787Z\",\"shell.execute_reply\":\"2024-06-10T19:52:04.450803Z\"}}\n\nmodel = CustomModel(CFG)\nmodel = model.to(CFG.device) # GPU Config\nstate = torch.load(OUTPUT_DIR+f\"{CFG.fusion_mode}_best_loss.pth\",\n                       map_location=torch.device('cpu'))\n\nmodel.load_state_dict(state['model'])\n\n# %% [code] {\"scrolled\":true,\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:52:04.452732Z\",\"iopub.status.idle\":\"2024-06-10T19:52:04.453482Z\",\"shell.execute_reply.started\":\"2024-06-10T19:52:04.453254Z\",\"shell.execute_reply\":\"2024-06-10T19:52:04.453273Z\"}}\nprint(model)\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:52:04.454712Z\",\"iopub.status.idle\":\"2024-06-10T19:52:04.455445Z\",\"shell.execute_reply.started\":\"2024-06-10T19:52:04.455228Z\",\"shell.execute_reply\":\"2024-06-10T19:52:04.455245Z\"}}\ndef generate_text_fn(test_loader, model, tokenizer, max_length=50, device=CFG.device):\n    # Set model to evaluation mode\n    model.eval()\n    \n    generated_texts = []\n\n    with torch.no_grad():\n        for step, batch in enumerate(test_loader):\n            # Load data from the test loader\n            input_ids, encoder_inputs, encoder_attn_mask, _ = batch\n            input_ids = input_ids.to(device)\n            encoder_inputs = encoder_inputs.to(device)\n            encoder_attn_mask = encoder_attn_mask.to(device)\n            \n#             outputs, t5_encoder_outputs = model(input_ids, encoder_inputs, \n#                                                 encoder_attn_mask, target_ids)\n\n            # Generate text\n            output_sequences = model.t5_model.generate(\n                input_ids=input_ids,\n                attention_mask=encoder_attn_mask,\n                max_length=max_length,\n                num_beams=4,  # Adjust as needed\n                early_stopping=True\n            )\n\n            # Decode generated sequences\n            generated_texts.extend([tokenizer.decode(output, skip_special_tokens=True) for output in output_sequences])\n\n    return generated_texts\n\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:52:04.456657Z\",\"iopub.status.idle\":\"2024-06-10T19:52:04.457379Z\",\"shell.execute_reply.started\":\"2024-06-10T19:52:04.457166Z\",\"shell.execute_reply\":\"2024-06-10T19:52:04.457184Z\"}}\ngenerated_texts = generate_text_fn(test_dataloader, model, CFG.t5_tokenizer)\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:52:04.458594Z\",\"iopub.status.idle\":\"2024-06-10T19:52:04.459319Z\",\"shell.execute_reply.started\":\"2024-06-10T19:52:04.459081Z\",\"shell.execute_reply\":\"2024-06-10T19:52:04.459098Z\"}}\ndf_test['predictions'] = generated_texts\ndf_test.head()\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:52:04.460619Z\",\"iopub.status.idle\":\"2024-06-10T19:52:04.461393Z\",\"shell.execute_reply.started\":\"2024-06-10T19:52:04.461160Z\",\"shell.execute_reply\":\"2024-06-10T19:52:04.461180Z\"}}\nexp_name = CFG.model_name.replace('/', '-') + \"_\" + CFG.encoder_name.replace('/', '-') + \"_\" + CFG.fusion_mode\nprint(exp_name)\ndf_test.to_csv(f\"./Our_Model_{exp_name}_Predictions.csv\", index = False)\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:52:04.462683Z\",\"iopub.status.idle\":\"2024-06-10T19:52:04.463454Z\",\"shell.execute_reply.started\":\"2024-06-10T19:52:04.463223Z\",\"shell.execute_reply\":\"2024-06-10T19:52:04.463242Z\"}}\nmodel = CustomModel(CFG, is_train = False)\nmodel = model.to(CFG.device) # GPU Config\nstate = torch.load(OUTPUT_DIR+f\"{CFG.fusion_mode}_best_loss.pth\",\n                       map_location=torch.device('cpu'))\n\nmodel.load_state_dict(state['model'])\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:52:04.464759Z\",\"iopub.status.idle\":\"2024-06-10T19:52:04.465552Z\",\"shell.execute_reply.started\":\"2024-06-10T19:52:04.465317Z\",\"shell.execute_reply\":\"2024-06-10T19:52:04.465337Z\"}}\ndef generate_single_text_fn(input_text, model, device=CFG.device):\n    # Set model to evaluation mode\n    model.eval()\n    model.to(device)\n    \n    decoder_input_ids = CFG.t5_tokenizer.encode(\"\", return_tensors='pt')\n    decoder_input_ids = decoder_input_ids.to(device)\n    \n    input_ids = CFG.t5_tokenizer.encode(input_text, return_tensors='pt', padding='max_length', \n                                                truncation=True, max_length=CFG.max_len)\n    \n    encoder_inputs = CFG.encoder_tokenizer(input_text, return_tensors='pt', padding='max_length', \n                                                truncation=True, max_length=CFG.max_len)\n    encoder_ids = encoder_inputs.input_ids\n    encoder_attn_mask = encoder_inputs.attention_mask\n    \n    input_ids = input_ids.to(device)\n    encoder_ids = encoder_ids.to(device)\n    encoder_attn_mask = encoder_attn_mask.to(device)\n\n    outputs, t5_encoder_outputs = model(input_ids, encoder_ids, \n                                        encoder_attn_mask)\n\n    # Generate text\n    output_sequences = model.t5_model.generate(\n            input_ids=None,  # The input_ids will be None since we use encoder_outputs directly\n            encoder_outputs=t5_encoder_outputs,\n            decoder_input_ids=decoder_input_ids,\n            max_length=50,  # Set the max length for generated text\n            num_beams=5,  # Beam search for better quality text\n            early_stopping=True  # Stop when the end token is generated\n        )\n\n    generated_text = CFG.t5_tokenizer.decode(output_sequences[0], skip_special_tokens=True)\n    return generated_text\n\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:52:04.466986Z\",\"iopub.status.idle\":\"2024-06-10T19:52:04.467496Z\",\"shell.execute_reply.started\":\"2024-06-10T19:52:04.467277Z\",\"shell.execute_reply\":\"2024-06-10T19:52:04.467295Z\"}}\ninput_text = \"Ami vaat khai\"\ntext = generate_single_text_fn(input_text, model)\ntext\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:52:04.469178Z\",\"iopub.status.idle\":\"2024-06-10T19:52:04.470095Z\",\"shell.execute_reply.started\":\"2024-06-10T19:52:04.469857Z\",\"shell.execute_reply\":\"2024-06-10T19:52:04.469876Z\"}}\n# # Set the model to evaluation mode\n# model.eval()\n\n# # Function to generate text for a test sample\n# def generate_text(input_text):\n#     input_ids = tokenizer(input_text, return_tensors='pt').input_ids\n    \n\n# t5_encoder_outputs\n#     # Prepare the decoder input\n#     decoder_input_ids = tokenizer.encode(\"\", return_tensors='pt')\n\n#     # Generate text using the decoder\n#     outputs = model.generate(\n#         input_ids=None,  # The input_ids will be None since we use encoder_outputs directly\n#         encoder_outputs=encoder_outputs,\n#         decoder_input_ids=decoder_input_ids,\n#         max_length=50,  # Set the max length for generated text\n#         num_beams=5,  # Beam search for better quality text\n#         early_stopping=True  # Stop when the end token is generated\n#     )\n\n#     # Decode the generated tokens to text\n#     generated_text = tokenizer.decode(outputs[0], skip_special_tokens=True)\n#     return generated_text\n\n# # Test input text\n# test_input_text = \"translate English to French: I love natural language processing.\"\n\n# # Generate text for the test sample\n# generated_output_text = generate_text(test_input_text)\n# print(\"Generated text:\", generated_output_text)\n\n# %% [code] {\"execution\":{\"iopub.status.busy\":\"2024-06-10T19:52:04.471237Z\",\"iopub.status.idle\":\"2024-06-10T19:52:04.472225Z\",\"shell.execute_reply.started\":\"2024-06-10T19:52:04.471970Z\",\"shell.execute_reply\":\"2024-06-10T19:52:04.471991Z\"}}\n# # For batch wise\n\n# from transformers import MarianMTModel, MarianTokenizer\n\n# # Load the MarianMTModel for English to French translation\n# model_name = \"Helsinki-NLP/opus-mt-en-fr\"\n# tokenizer = MarianTokenizer.from_pretrained(model_name)\n# model = MarianMTModel.from_pretrained(model_name)\n\n# # Define a list of input sentences in English\n# input_texts = [\"Hello, how are you?\", \"What is your name?\", \"How was your day?\"]\n\n# # Tokenize the input texts\n# inputs = tokenizer(input_texts, return_tensors=\"pt\", padding=True, truncation=True)\n\n# # Translate the input texts in batch\n# translated = model.generate(**inputs)\n\n# # Decode the translated outputs\n# translated_texts = tokenizer.batch_decode(translated, skip_special_tokens=True)\n\n# # Print the translated texts\n# for input_text, translated_text in zip(input_texts, translated_texts):\n#     print(\"Input:\", input_text)\n#     print(\"Translated:\", translated_text)\n#     print()\n","metadata":{"_uuid":"00ede3ad-30cf-4641-b70b-af13f9b7100a","_cell_guid":"1ba5ca0d-c880-4f2f-933e-2cb33256cd30","collapsed":false,"jupyter":{"outputs_hidden":false},"trusted":true},"execution_count":null,"outputs":[]}]}