export REPO_ROOT=

export CARLA_ROOT=${REPO_ROOT}/carla/CARLA_0.9.10.1
export CARLA_SERVER=${CARLA_ROOT}/CarlaUE4.sh
export LEADERBOARD_ROOT=${REPO_ROOT}/leaderboard
export SCENARIO_RUNNER_ROOT=${REPO_ROOT}/scenario_runner

export PYTHONPATH=${PYTHONPATH}:${REPO_ROOT}/src
export PYTHONPATH=${PYTHONPATH}:${CARLA_ROOT}/PythonAPI
export PYTHONPATH=${PYTHONPATH}:${CARLA_ROOT}/PythonAPI/carla
export PYTHONPATH=${PYTHONPATH}:${CARLA_ROOT}/PythonAPI/carla/dist/carla-0.9.10-py3.7-linux-x86_64.egg
export PYTHONPATH=${PYTHONPATH}:${LEADERBOARD_ROOT}
export PYTHONPATH=${PYTHONPATH}:${SCENARIO_RUNNER_ROOT}

echo "$PYTHONPATH"

#export SCENARIOS=${LEADERBOARD_ROOT}/data/scenarios/all_towns_traffic_scenarios_public.json
#export ROUTES=${LEADERBOARD_ROOT}/data/langauto/benchmark_short.xml
export SCENARIOS=${LEADERBOARD_ROOT}/data/scenarios/eval_scenarios.json
export ROUTES=${LEADERBOARD_ROOT}/data/longest6_split/longest_weathers_0.xml
export REPETITIONS=1
export DEBUG_CHALLENGE=0
export TEAM_AGENT=${REPO_ROOT}/src/dt/dt_agent.py
export TEAM_CONFIG=${REPO_ROOT}/src/dt/config/expert.yaml
export CHECKPOINT_ENDPOINT=${LEADERBOARD_ROOT}/run.json
export CHALLENGE_TRACK_CODENAME=SENSORS
export RESUME=False

#export HAS_DISPLAY=1

cd ${REPO_ROOT} || exit
python3 ${REPO_ROOT}/leaderboard/leaderboard/leaderboard_evaluator.py \
  --scenarios=${SCENARIOS} \
  --routes=${ROUTES} \
  --repetitions=${REPETITIONS} \
  --track=${CHALLENGE_TRACK_CODENAME} \
  --checkpoint=${CHECKPOINT_ENDPOINT} \
  --agent=${TEAM_AGENT} \
  --agent-config=${TEAM_CONFIG} \
  --debug=${DEBUG_CHALLENGE} \
  --record=${RECORD_PATH} \
  --resume=${RESUME}
