from encoding_method import caesar_encrypt
import string
from random import shuffle, random, randint, sample
import copy
def ceaser_extrapolating(shift=3, reveal=3, noised=False, noise_num=2):
    if not noised:
        encrypt = caesar_encrypt("ABCDEFGHIJKLMNOPQRSTUVWXYZ", shift)
        table = []
        for en, de in zip(encrypt[:reveal], string.ascii_uppercase[:reveal]):
            table.append({"Original": de, "Altered": en})
        return table
    elif noised:
        encrypt = caesar_encrypt("ABCDEFGHIJKLMNOPQRSTUVWXYZ", shift)
        table = []
        for en, de in zip(encrypt[:reveal], string.ascii_uppercase[:reveal]):
            table.append({"Original": de, "Altered": en})
        sampled_idx = sample(range(len(table)), noise_num)
        noised_table = copy.copy(table)
        noised_table[sampled_idx[0]]["Altered"] = table[sampled_idx[1]]["Altered"]
        noised_table[sampled_idx[1]]["Altered"] = table[sampled_idx[0]]["Altered"]
        return table, noised_table, sampled_idx

