import os
import re

from .openai_utils import (chatgpt_chatbot_editing,
                           chatgpt_zero_shot_classification, join_hist)


def is_rationale_first_offer(passage):
    prompt = f""" We are here in the context of a negotiation.
    Your task is to detect if the buyer gives sufficient rationale/argument along with their offer or not in the passage.

    We think of rationales as a piece of argumentation that can justify a mentioned price. 
    Rationales should be related to the item purchased (clearly mentioning some specific features or price ranges etc…). 
    Nevertheless, we can think of exceptions such as “You're a friend so I can maybe push it a bit to…”

    #Example

    Passage: "Buyer: Hello I'd like to make an offer
              Seller: Great what were you thinking ?
              Buyer: I don't know something like 10k ?"
    Rationale :False

    Passage: "Buyer: Hello, this car is in great shape for its mileage, I was looking
                   for a similar car on the internet. I like it and my kids would have a great time in it.
                   Can I make an offer ?
              Seller: Sure how much ?
              Buyer: Something around 10k ?"
    Rationale :True

    Passage: "Buyer: Yeah I guess i can do 12,500. It seems reasonable.
              Seller: Can you push it more to 13,5?
              Buyer: No sorry, 12,5 nothing more."
    Rationale : False

    #Task

    Passage : "{passage}"
    Rationale :Answer here
      
    """

    edit = chatgpt_zero_shot_classification(
        messages=[
            {"role": "system", "content": prompt},
        ],
    )

    return re.sub(r"\b(?!True|False)\w+\b", "", edit)


def is_rationale(passage):
    prompt = f""" We are here in the context of a negotiation.
    Your task is to detect if the buyer gives sufficient rationale/argument along with their offer or not in the passage.

    We think of rationales as any chit-chat accompagnying an offer to justify the price.
    Rationales should be related to the item purchased (clearly mentioning some specific features or price ranges etc…).
    The only thing is that we don't want the buyer to give 0 context to their offer.

    #Example

    Passage: "Buyer: Hello I'd like to make an offer
              Seller: Great what were you thinking ?
              Buyer: I don't know something like 10k ?"
    Rationale :False

    Passage: "Buyer: Hello, this car is in great shape for its mileage, I was looking
                   for a similar car on the internet. I like it and my kids would have a great time in it.
                   Can I make an offer ?
              Seller: Sure how much ?
              Buyer: Something around 10k ?"
    Rationale :True

    Passage: "Buyer: Yeah I guess i can do 12,500. It seems reasonable.
              Seller: Can you push it more to 13,5?
              Buyer: No sorry, 12,5."
    Rationale : False

    Passage: "Buyer: I can pay 13k"
              Seller: That's not enough!
              Buyer: I like you, I really want this negotiation to reach a deal. But this is my maximum."
    Rationale : True

    #Task

    Passage : "{passage}"
    Rationale :Answer here
      
    """

    edit = chatgpt_zero_shot_classification(
        messages=[
            {"role": "system", "content": prompt},
        ],
    )

    return re.sub(r"\b(?!True|False)\w+\b", "", edit)


def edit_rationale_first_offer(passage):

    prompt = f""" We are here in the context of a negotiation. You are an assistant aimed help a buyer in a negotiation and give them comments on their offers.
                In this passage: {passage}

                The buyer did not give enough arguments to justify their offer.

                Give the buyer a quick explanation. Try to quote some words the buyer said.
                
                EXAMPLE OF EXPLANATION:
                "Negotiation research finds that opening offers are most effective when accompanied by a rationale in terms of some objective reference point, such as an expert’s valuation of the object under negotiation or market value indicated by past sales prices." 
                """
    edit = chatgpt_chatbot_editing(
        messages=[
            {"role": "system", "content": prompt},
        ],
    )
    return re.sub(r"Buyer:|Seller:", "", edit)


def edit_rationale(passage):

    prompt = f""" We are here in the context of a negotiation. You are an assistant aimed help a buyer in a negotiation and give them comments on their offers.
                In this passage: {passage}

                The buyer did not give enough arguments to justify their offer.

                Give the buyer a quick explanation. Try to quote some words the buyer said.
                
                EXAMPLE OF EXPLANATION:
                "When you present a revised offer, it’s persuasive to give some explanation for the move. Why are you offering more? Why are you resisting offering everything they ask for? The explanations you provide may be subjective, such as your eagerness to reach a deal or your pressing budget constraints, but some words of explanation like this help the seller understand and accept your perspective. " 
                """
    edit = chatgpt_chatbot_editing(
        messages=[
            {"role": "system", "content": prompt},
        ],
    )
    return re.sub(r"Buyer:|Seller:", "", edit)
