/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.util.Generics;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Set;

public class CTBunkDict {
    private static final String defaultFilename = "ctb_amb";
    private static CTBunkDict CTBunkDictSingleton = null;
    private static Map<String, Set<String>> CTBunk_dict;

    private static CTBunkDict getInstance() {
        if (CTBunkDictSingleton == null) {
            CTBunkDictSingleton = new CTBunkDict();
        }
        return CTBunkDictSingleton;
    }

    private CTBunkDict() {
        CTBunkDict.readCTBunkDict("/u/nlp/data/pos-tagger/dictionary/ctb_amb");
    }

    private static void readCTBunkDict(String filename) {
        CTBunk_dict = Generics.newHashMap();
        try {
            String CTBunkDetectorLine;
            BufferedReader CTBunkDetectorReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "GB18030"));
            while ((CTBunkDetectorLine = CTBunkDetectorReader.readLine()) != null) {
                String[] fields = CTBunkDetectorLine.split(" ");
                String tag = fields[1];
                Set<String> words = CTBunk_dict.get(tag);
                if (words == null) {
                    words = Generics.newHashSet();
                    CTBunk_dict.put(tag, words);
                }
                words.add(fields[0]);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeIOException("CTBunk file not found: " + filename, e);
        }
        catch (IOException e) {
            throw new RuntimeIOException("CTBunk I/O error: " + filename, e);
        }
    }

    protected static String getTag(String tag, String word) {
        CTBunkDict dict = CTBunkDict.getInstance();
        Set<String> words = CTBunkDict.get(tag);
        if (words != null && words.contains(word)) {
            return "1";
        }
        return "0";
    }

    private static Set<String> get(String a) {
        return CTBunk_dict.get(a);
    }
}

