## Set the Paths
First, set the corresponding paths of "Step 1" in `_settings.py`.

## Generate the responses
Use the `llama2-13b`, `gemma-7b` or `mistralai/Mistral-7B-v0.1` for model, and `coqa_new`, `triviaqa_new` and `nq_open_new` for the dataset  below.
```
python -m pipeline.generate --model llama2-13b --dataset coqa_new
```

Update `GEN_PATHS` in `_settings.py` for next steps.

## Replicate experiments

First, add all tasks to a queue on disk, by running
```
python -m scripts.dq_add
```

Then, run the actual computation via the following (in sequence). You could specify the device to use via `-d [device_numbers]`
```
python -m scripts.dq_work -q qAll_1 -d 1
python -m scripts.dq_work -q qAll_2 -d 1
python -m scripts.dq_work -q qMult -d 0,1,2 # This runs a 70B model so might require more GPUs
python -m scripts.dq_work -q qAPI # This queue has only GPT API calls, so no GPU is needed
```

## Optional But Recommended Caching
After all queues finished, you can optionally run the following to cache down some summarization.
```
python -m pipeline.uq
python -m scripts.cache
```

## Run the Notebooks
Then, you can run `notebook/demo.ipynb` (or other notebooks)