theory question_61_1

imports Main

begin

typedecl entity

consts
  SolarSystemBody :: "entity ⇒ bool"
  Sun :: "entity ⇒ bool"
  Larger :: "entity ⇒ entity ⇒ bool"

theorem hypothesis:
  assumes asm: "SolarSystemBody x"
  (* Hypothesis: The largest body in the solar system is the sun. *)
  shows "Sun x"
proof -
  obtain y where sun: "Sun y" using explanation_1 by blast
  have "SolarSystemBody y" using explanation_4 by blast
  have "Larger y x" using explanation_1 by blast
  have "Larger x y ⟶ x = y" by simp
  have "x = y" by metis sun[OF this]
  have "SolarSystemBody x" using this by simp
  show "Sun x" using sun by simp
qed

end
