theory question_87_2

imports Main

begin

typedecl entity

consts
  Tunicate :: "entity ⇒ bool"
  Bulbs :: "entity ⇒ bool"
  ReproduceSexually :: "entity ⇒ bool"

(* Explanation 1: Tunicates, which include bulbs if they are classified as such, reproduce sexually. *)
axiomatization where
  explanation_1: "∀x. Tunicate x ∧ (Bulbs x ∨ ¬Bulbs x) ⟶ ReproduceSexually x"

(* Explanation 2: If bulbs are classified as tunicates, then they reproduce sexually as part of the tunicate sexual reproduction. *)
axiomatization where
  explanation_2: "(∀x. Bulbs x ⟶ Tunicate x) ⟶ (∀x. Bulbs x ⟶ ReproduceSexually x)"

(* Explanation 3: Bulbs can be classified as tunicates or non-tunicates. *)
axiomatization where
  explanation_3: "∀x. Bulbs x ⟶ (Tunicate x ∨ ¬Tunicate x)"

theorem hypothesis:
  assumes asm: "Bulbs x"
  (* Hypothesis: Bulbs reproduce sexually. *)
  shows "ReproduceSexually x"
proof -
  have "Tunicate x ∨ ¬Tunicate x" using explanation_3 by blast
  then have "ReproduceSexually x" if "Tunicate x" using explanation_1 by blast
  show "ReproduceSexually x" using asm this by blast
qed

end
