theory question_85_6
imports Main

begin

typedecl entity
typedecl event

consts
  PacinianCorpuscles :: "entity ⇒ bool"
  PressureReceptors :: "entity ⇒ bool"
  LocationProperties :: "entity ⇒ entity ⇒ bool"
  MainlyFoundIn :: "entity ⇒ entity ⇒ bool"
  Skin :: entity

(* Explanation 1: Pacinian corpuscles are a specific type of pressure receptors and share all the location properties of pressure receptors. *)
axiomatization where
  explanation_1: "∀x. PacinianCorpuscles x ⟶ (PressureReceptors x ∧ (∀y z. LocationProperties y x ⟷ LocationProperties y z ⟹ LocationProperties z x))"

(* Explanation 2: Pressure receptors are mainly found in the skin. *)
axiomatization where
  explanation_2: "∀x. PressureReceptors x ⟶ MainlyFoundIn x Skin"

(* Explanation 3: If an entity shares all the location properties of pressure receptors, then it is mainly found in the same locations as the pressure receptors. *)
axiomatization where
  explanation_3: "∀x y. (∀z. LocationProperties z x ⟷ LocationProperties z y) ⟶ (∀l. MainlyFoundIn x l ⟷ MainlyFoundIn y l)"

theorem hypothesis:
  assumes asm: "PacinianCorpuscles x"
  (* Hypothesis: Pacinian corpuscles are found mainly in the skin. *)
  shows "MainlyFoundIn x Skin"
proof -
  from asm have "PacinianCorpuscles x" by simp
  then obtain y where y: "PressureReceptors y ∧ (∀z w. LocationProperties z x ⟷ LocationProperties z w ⟹ LocationProperties w x)" using explanation_1 by blast
  then have "MainlyFoundIn y Skin" using explanation_2 by blast
  have "∀z. LocationProperties z x ⟷ LocationProperties z y" using y by auto
  then have "∀l. MainlyFoundIn x l ⟷ MainlyFoundIn y l" using explanation_3 by blast
  then have "MainlyFoundIn x Skin" using ‹MainlyFoundIn y Skin› by blast
  show ?thesis using asm ‹MainlyFoundIn x Skin› by blast
qed

end
