theory question_81_5

imports Main

begin

typedecl entity
typedecl event
consts
  Person :: "entity ⇒ bool"
  Bicycle :: "entity ⇒ bool"
  Riding :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Helmet :: "entity ⇒ bool"
  Jumping :: "event ⇒ bool"
  Soaring :: "event ⇒ bool"
  InFrontOf :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A person exists and is riding a bicycle outside. *)
axiomatization where
  explanation_1: "∃x y e. Person x ∧ Bicycle y ∧ Riding e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  (* Premise: A person on a bicycle wears a helmet and jumps, soaring over the ground in front of a skyline and lake. *)
  assumes asm: "Person x ∧ Bicycle y ∧ Helmet z ∧ Jumping e ∧ Soaring e ∧ Agent e x ∧ Patient e y ∧ InFrontOf x z"
  (* Hypothesis: A person outside with a bike. *)
  shows "∃x y e. Person x ∧ Bicycle y ∧ Riding e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Person x ∧ Bicycle y ∧ Helmet z ∧ Jumping e ∧ Soaring e ∧ Agent e x ∧ Patient e y ∧ InFrontOf x z" by blast
  then have "∃x y e. Person x ∧ Bicycle y ∧ Riding e ∧ Agent e x ∧ Patient e y" using explanation_1 by blast
  show ?thesis using `Person x` `Bicycle y` `Riding e` `Agent e x` `Patient e y` by blast
qed

end
