theory question_36_3

imports Main

begin
typedecl entity
typedecl event

consts
  BusyCityStreet :: "entity ⇒ bool"
  Place :: "entity ⇒ bool"
  ALotOfPeople :: "entity ⇒ bool"
  People :: "entity ⇒ bool"
  Street :: "entity ⇒ bool"
  Walking :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Down :: "event ⇒ entity ⇒ bool"
  Has :: "entity ⇒ entity ⇒ bool"
  Winter :: "entity ⇒ bool"
  In :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A busy city street is a place that has a lot of people. *)
axiomatization where
  explanation_1: "∀x. BusyCityStreet x ⟶ Place x ∧ ALotOfPeople x"

(* Explanation 2: People walking down a street means that the street has those people. *)
axiomatization where  
  explanation_2: "∀x y e. People x ∧ Street y ∧ Walking e ∧ Agent e x ∧ Down e y ⟶ Has y x"

(* Explanation 3: A busy city street is a street. *)
axiomatization where  
  explanation_3: "∀x. BusyCityStreet x ⟶ Street x"

theorem hypothesis:
  (* Premise: People walking down a busy city street in the winter. *)
  assumes asm: "People x ∧ BusyCityStreet y ∧ Winter z ∧ Walking e ∧ Agent e x ∧ Down e y ∧ In e z"
  (* Hypothesis: The street has a lot of people. *)
  shows "∃x. Street x ∧ ALotOfPeople x"
proof -
  from asm have "People x ∧ BusyCityStreet y ∧ Walking e ∧ Agent e x ∧ Down e y" by blast
  then have "Has y x" using explanation_2 by blast
  from asm have "BusyCityStreet y" by blast
  then have "Place y ∧ ALotOfPeople y" using explanation_1 by blast
  then have "Street y ∧ ALotOfPeople y" using explanation_3 `BusyCityStreet y` by blast
  then show ?thesis using `Street y` `ALotOfPeople y` by blast
qed

end
