theory question_81_8

imports Main

begin

typedecl entity
typedecl event

consts
  Soil :: "entity ⇒ bool"
  NonlivingEntity :: "entity ⇒ bool"
  Environments :: "entity ⇒ bool"
  Forest :: "entity ⇒ bool"
  NonlivingComponentOf :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Soil is a nonliving entity and typically a nonliving component of environments, such as forests. *)
axiomatization where
  explanation_1: "∀x. Soil x ⟶ NonlivingEntity x ∧ (∀y. Environments y ∧ Forest y ⟶ NonlivingComponentOf x y)"

(* Explanation 2: Soil is typically a nonliving component of environments, such as forests, and specifically a nonliving part of a forest. *)
axiomatization where
  explanation_2: "∀x y. Soil x ⟶ NonlivingComponentOf x y ∧ Forest y"

theorem hypothesis:
  assumes asm: "Soil x ∧ Forest y"
  (* Hypothesis: Soil is a nonliving part of a forest. *)
  shows "NonlivingPartOf x y"
proof -
  from asm have "Soil x" and "Forest y" by auto
  then have "NonlivingComponentOf x y" using explanation_2 by blast
  then have "NonlivingPartOf x y" using explanation_1 by blast
  then show ?thesis using `Soil x` `Forest y` by blast
qed

end
