import csv

csv_path = "lex_stats/most_common_validinvalid.csv"
invalid_words = "wordlists/alphabetic_invalid.txt"

with open(invalid_words, 'r') as f:
    wordlists = f.readlines()

wordlists = [word.rstrip() for word in wordlists]

wordfreq = dict()

with open(csv_path) as f:
    for line in f:
        line = line.strip('\n')
        (term, freq) = line.split(",")

        if term in wordlists:
            wordfreq[term] = freq

invalid_csv = "lex_stats/common_invalid.csv"
f = open(invalid_csv, 'w')

writer = csv.writer(f)

for k, v in wordfreq.items():
    writer.writerow([k, v])

f.close()
