import os
import sys
import argparse


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument('-i', type=str, default="input dir")
    parser.add_argument('-o', type=str, default="outputdir")
    args = parser.parse_args()

    files = [f for f in os.listdir(args.i) if f.endswith('doc') or f.endswith('sum')]
    if not os.path.exists(args.o):
        os.mkdir(args.o)

    for f in files:
        infile = os.path.join(args.i, f)
        outfile = os.path.join(args.o, f)

        with open(infile, 'rb') as fin, open(outfile, 'w') as fout:
            for line in fin:
                fout.write('{}\n'.format(line.decode('utf-8').replace(u'\u2028', '').replace('\r', '').strip()))