name = "denoise_ranksummgen_lang5"

args = ["/home/tiger/{}/resource/dataset".format(name),
        "--cpu",
        "--distributed-world-size", "1",
        "--save-dir", "/home/tiger/{}/output/checkpoint_path".format(name),
        "--tensorboard-logdir", "/home/tiger/{}/output/tensorboard_logdir".format(name),
        "--restore-file", "{}/model/mbart.cc25/model.pt", 
        "--task", "denoise_ranking_summarization",
        "--arch", "rank_summ_gen_large",
        "--criterion", "cross_entropy_and_ranking_document",
        # "--task", "denoise_ranking_summarization",
        # "--arch", "rank_summ_large",
        # "--criterion", "cross_entropy_and_ranking",
        "--source-lang", "doc", "--target-lang", "sum",
        "--langs", "ar_AR,cs_CZ,de_DE,en_XX,es_XX,et_EE,fi_FI,fr_XX,gu_IN,hi_IN,it_IT,ja_XX,kk_KZ,ko_KR,lt_LT,lv_LV,my_MM,ne_NP,nl_XX,ro_RO,ru_RU,si_LK,tr_TR,vi_VN,zh_CN",
        "--dataset-impl", "mmap",
        "--truncate-source",
        "--encoder-normalize-before", "--decoder-normalize-before",
        "--layernorm-embedding",
        "--label-smoothing", "0.2",
        "--reset-optimizer", "--reset-dataloader", "--reset-meters", "--reset-lr-scheduler",
        '--required-batch-size-multiple', '1', '--dropout', '0.1', '--attention-dropout', '0.1', 
        '--weight-decay', '0.01', '--optimizer', 'adam', '--adam-betas', '(0.9, 0.999)', '--adam-eps', '1e-08', 
        '--lr', '3e-5', '--min-lr', '-1', '--lr-scheduler', 'polynomial_decay', '--clip-norm', '0.1', '--update-freq', '4', 
        '--skip-invalid-size-inputs-valid-test', '--find-unused-parameters', '--num-workers', '100', 
        '--max-tokens', '4096', '--total-num-update', '200000', '--warmup-updates', '2500', '--log-interval', '200', 
        '--log-format', 'simple', '--keep-best-checkpoints', '3', '--no-epoch-checkpoints', '--patience', '3', 
        '--user-dir', 'examples/summarization', '--ranking-head-name', 'sentence_contrastive_head',
        '--negative-sample-number', '2', '--ranking-loss-weight', '1'
    ]

from fairseq_cli.train import cli_main_with_args_list

if __name__ == "__main__":
    cli_main_with_args_list(args)